/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.s3.AmazonS3Reference;
import org.elasticsearch.repositories.s3.S3BasicCredentials;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3Repository;
import org.elasticsearch.repositories.s3.SocketAccess;

class S3Service
implements Closeable {
    private static final Logger logger = LogManager.getLogger(S3Service.class);
    private volatile Map<S3ClientSettings, AmazonS3Reference> clientsCache = Collections.emptyMap();
    private volatile Map<String, S3ClientSettings> staticClientSettings = MapBuilder.newMapBuilder().put((Object)"default", (Object)S3ClientSettings.getClientSettings(Settings.EMPTY, "default")).immutableMap();
    private volatile Map<Settings, S3ClientSettings> derivedClientSettings = Collections.emptyMap();

    S3Service() {
    }

    public synchronized void refreshAndClearCache(Map<String, S3ClientSettings> clientsSettings) {
        this.releaseCachedClients();
        this.staticClientSettings = MapBuilder.newMapBuilder(clientsSettings).immutableMap();
        this.derivedClientSettings = Collections.emptyMap();
        assert (this.staticClientSettings.containsKey("default")) : "always at least have 'default'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonS3Reference client(RepositoryMetadata repositoryMetadata) {
        S3ClientSettings clientSettings = this.settings(repositoryMetadata);
        AmazonS3Reference clientReference = this.clientsCache.get(clientSettings);
        if (clientReference != null && clientReference.tryIncRef()) {
            return clientReference;
        }
        S3Service s3Service = this;
        synchronized (s3Service) {
            AmazonS3Reference existing = this.clientsCache.get(clientSettings);
            if (existing != null && existing.tryIncRef()) {
                return existing;
            }
            AmazonS3Reference clientReference2 = new AmazonS3Reference(this.buildClient(clientSettings));
            clientReference2.incRef();
            this.clientsCache = MapBuilder.newMapBuilder(this.clientsCache).put((Object)clientSettings, (Object)clientReference2).immutableMap();
            return clientReference2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    S3ClientSettings settings(RepositoryMetadata repositoryMetadata) {
        Settings settings = repositoryMetadata.settings();
        S3ClientSettings existing = this.derivedClientSettings.get(settings);
        if (existing != null) {
            return existing;
        }
        String clientName = (String)S3Repository.CLIENT_NAME.get(settings);
        S3ClientSettings staticSettings = this.staticClientSettings.get(clientName);
        if (staticSettings != null) {
            S3Service s3Service = this;
            synchronized (s3Service) {
                S3ClientSettings existing2 = this.derivedClientSettings.get(settings);
                if (existing2 != null) {
                    return existing2;
                }
                S3ClientSettings newSettings = staticSettings.refine(settings);
                this.derivedClientSettings = MapBuilder.newMapBuilder(this.derivedClientSettings).put((Object)settings, (Object)newSettings).immutableMap();
                return newSettings;
            }
        }
        throw new IllegalArgumentException("Unknown s3 client name [" + clientName + "]. Existing client configs: " + Strings.collectionToDelimitedString(this.staticClientSettings.keySet(), (String)","));
    }

    AmazonS3 buildClient(S3ClientSettings clientSettings) {
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        builder.withCredentials(S3Service.buildCredentials(logger, clientSettings));
        builder.withClientConfiguration(S3Service.buildConfiguration(clientSettings));
        String endpoint = Strings.hasLength((String)clientSettings.endpoint) ? clientSettings.endpoint : "s3.amazonaws.com";
        if (!(endpoint.startsWith("http://") || endpoint.startsWith("https://"))) {
            endpoint = clientSettings.protocol.toString() + "://" + endpoint;
        }
        String region = Strings.hasLength((String)clientSettings.region) ? clientSettings.region : null;
        logger.debug("using endpoint [{}] and region [{}]", (Object)endpoint, (Object)region);
        builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, region));
        if (clientSettings.pathStyleAccess) {
            builder.enablePathStyleAccess();
        }
        if (clientSettings.disableChunkedEncoding) {
            builder.disableChunkedEncoding();
        }
        return SocketAccess.doPrivileged(() -> ((AmazonS3ClientBuilder)builder).build());
    }

    static ClientConfiguration buildConfiguration(S3ClientSettings clientSettings) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol(clientSettings.protocol);
        if (Strings.hasText((String)clientSettings.proxyHost)) {
            clientConfiguration.setProxyHost(clientSettings.proxyHost);
            clientConfiguration.setProxyPort(clientSettings.proxyPort);
            clientConfiguration.setProxyUsername(clientSettings.proxyUsername);
            clientConfiguration.setProxyPassword(clientSettings.proxyPassword);
        }
        if (Strings.hasLength((String)clientSettings.signerOverride)) {
            clientConfiguration.setSignerOverride(clientSettings.signerOverride);
        }
        clientConfiguration.setMaxErrorRetry(clientSettings.maxRetries);
        clientConfiguration.setUseThrottleRetries(clientSettings.throttleRetries);
        clientConfiguration.setSocketTimeout(clientSettings.readTimeoutMillis);
        return clientConfiguration;
    }

    static AWSCredentialsProvider buildCredentials(Logger logger, S3ClientSettings clientSettings) {
        S3BasicCredentials credentials = clientSettings.credentials;
        if (credentials == null) {
            logger.debug("Using instance profile credentials");
            return new PrivilegedInstanceProfileCredentialsProvider();
        }
        logger.debug("Using basic key/secret credentials");
        return new AWSStaticCredentialsProvider((AWSCredentials)credentials);
    }

    private synchronized void releaseCachedClients() {
        for (AmazonS3Reference clientReference : this.clientsCache.values()) {
            clientReference.decRef();
        }
        this.clientsCache = Collections.emptyMap();
        this.derivedClientSettings = Collections.emptyMap();
        IdleConnectionReaper.shutdown();
    }

    @Override
    public void close() {
        this.releaseCachedClients();
    }

    static class PrivilegedInstanceProfileCredentialsProvider
    implements AWSCredentialsProvider {
        private final AWSCredentialsProvider credentials = new EC2ContainerCredentialsProviderWrapper();

        private PrivilegedInstanceProfileCredentialsProvider() {
        }

        public AWSCredentials getCredentials() {
            return SocketAccess.doPrivileged(() -> ((AWSCredentialsProvider)this.credentials).getCredentials());
        }

        public void refresh() {
            SocketAccess.doPrivilegedVoid(() -> ((AWSCredentialsProvider)this.credentials).refresh());
        }
    }
}

