/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.s3.S3BlobStore;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3Service;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.Scheduler;

class S3Repository
extends BlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(S3Repository.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
    static final String TYPE = "s3";
    static final Setting<SecureString> ACCESS_KEY_SETTING = SecureSetting.insecureString((String)"access_key");
    static final Setting<SecureString> SECRET_KEY_SETTING = SecureSetting.insecureString((String)"secret_key");
    private static final ByteSizeValue DEFAULT_BUFFER_SIZE = new ByteSizeValue(Math.max(ByteSizeUnit.MB.toBytes(5L), Math.min(ByteSizeUnit.MB.toBytes(100L), JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 20L)), ByteSizeUnit.BYTES);
    static final Setting<String> BUCKET_SETTING = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[0]);
    static final Setting<Boolean> SERVER_SIDE_ENCRYPTION_SETTING = Setting.boolSetting((String)"server_side_encryption", (boolean)false, (Setting.Property[])new Setting.Property[0]);
    static final ByteSizeValue MAX_FILE_SIZE = new ByteSizeValue(5L, ByteSizeUnit.GB);
    static final ByteSizeValue MIN_PART_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.MB);
    static final ByteSizeValue MAX_PART_SIZE_USING_MULTIPART = MAX_FILE_SIZE;
    static final ByteSizeValue MAX_FILE_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.TB);
    static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting((String)"buffer_size", (ByteSizeValue)DEFAULT_BUFFER_SIZE, (ByteSizeValue)MIN_PART_SIZE_USING_MULTIPART, (ByteSizeValue)MAX_PART_SIZE_USING_MULTIPART, (Setting.Property[])new Setting.Property[0]);
    static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.GB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.TB), (Setting.Property[])new Setting.Property[0]);
    static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting((String)"compress", (boolean)false, (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> STORAGE_CLASS_SETTING = Setting.simpleString((String)"storage_class", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> CANNED_ACL_SETTING = Setting.simpleString((String)"canned_acl", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> CLIENT_NAME = new Setting("client", "default", Function.identity(), new Setting.Property[0]);
    static final Setting<TimeValue> COOLDOWN_PERIOD = Setting.timeSetting((String)"cooldown_period", (TimeValue)new TimeValue(3L, TimeUnit.MINUTES), (TimeValue)new TimeValue(0L, TimeUnit.MILLISECONDS), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic});
    static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[0]);
    private final S3Service service;
    private final String bucket;
    private final ByteSizeValue bufferSize;
    private final ByteSizeValue chunkSize;
    private final BlobPath basePath;
    private final boolean serverSideEncryption;
    private final String storageClass;
    private final String cannedACL;
    private final RepositoryMetaData repositoryMetaData;
    private final TimeValue coolDown;
    private final AtomicReference<Scheduler.Cancellable> finalizationFuture = new AtomicReference();

    S3Repository(RepositoryMetaData metadata, NamedXContentRegistry namedXContentRegistry, S3Service service, ClusterService clusterService) {
        super(metadata, ((Boolean)COMPRESS_SETTING.get(metadata.settings())).booleanValue(), namedXContentRegistry, clusterService);
        this.service = service;
        this.repositoryMetaData = metadata;
        this.bucket = (String)BUCKET_SETTING.get(metadata.settings());
        if (this.bucket == null) {
            throw new RepositoryException(metadata.name(), "No bucket defined for s3 repository");
        }
        this.bufferSize = (ByteSizeValue)BUFFER_SIZE_SETTING.get(metadata.settings());
        this.chunkSize = (ByteSizeValue)CHUNK_SIZE_SETTING.get(metadata.settings());
        if (this.chunkSize.getBytes() < this.bufferSize.getBytes()) {
            throw new RepositoryException(metadata.name(), CHUNK_SIZE_SETTING.getKey() + " (" + this.chunkSize + ") can't be lower than " + BUFFER_SIZE_SETTING.getKey() + " (" + this.bufferSize + ").");
        }
        String basePath = (String)BASE_PATH_SETTING.get(metadata.settings());
        this.basePath = Strings.hasLength((String)basePath) ? new BlobPath().add(basePath) : BlobPath.cleanPath();
        this.serverSideEncryption = (Boolean)SERVER_SIDE_ENCRYPTION_SETTING.get(metadata.settings());
        this.storageClass = (String)STORAGE_CLASS_SETTING.get(metadata.settings());
        this.cannedACL = (String)CANNED_ACL_SETTING.get(metadata.settings());
        if (S3ClientSettings.checkDeprecatedCredentials(metadata.settings())) {
            deprecationLogger.deprecated("Using s3 access/secret key from repository settings. Instead store these in named clients and the elasticsearch keystore for secure settings.", new Object[0]);
        }
        this.coolDown = (TimeValue)COOLDOWN_PERIOD.get(metadata.settings());
        logger.debug("using bucket [{}], chunk_size [{}], server_side_encryption [{}], buffer_size [{}], cannedACL [{}], storageClass [{}]", (Object)this.bucket, (Object)this.chunkSize, (Object)this.serverSideEncryption, (Object)this.bufferSize, (Object)this.cannedACL, (Object)this.storageClass);
    }

    public void finalizeSnapshot(SnapshotId snapshotId, ShardGenerations shardGenerations, long startTime, String failure, int totalShards, List<SnapshotShardFailure> shardFailures, long repositoryStateId, boolean includeGlobalState, MetaData clusterMetaData, Map<String, Object> userMetadata, Version repositoryMetaVersion, ActionListener<SnapshotInfo> listener) {
        if (!SnapshotsService.useShardGenerations((Version)repositoryMetaVersion)) {
            listener = this.delayedListener(listener);
        }
        super.finalizeSnapshot(snapshotId, shardGenerations, startTime, failure, totalShards, shardFailures, repositoryStateId, includeGlobalState, clusterMetaData, userMetadata, repositoryMetaVersion, listener);
    }

    public void deleteSnapshot(SnapshotId snapshotId, long repositoryStateId, Version repositoryMetaVersion, ActionListener<Void> listener) {
        if (!SnapshotsService.useShardGenerations((Version)repositoryMetaVersion)) {
            listener = this.delayedListener(listener);
        }
        super.deleteSnapshot(snapshotId, repositoryStateId, repositoryMetaVersion, listener);
    }

    private <T> ActionListener<T> delayedListener(ActionListener<T> listener) {
        final ActionListener wrappedListener = ActionListener.runBefore(listener, () -> {
            Scheduler.Cancellable cancellable = this.finalizationFuture.getAndSet(null);
            assert (cancellable != null);
        });
        return new ActionListener<T>(){

            public void onResponse(T response) {
                S3Repository.this.logCooldownInfo();
                Scheduler.Cancellable existing = (Scheduler.Cancellable)S3Repository.this.finalizationFuture.getAndSet(S3Repository.this.threadPool.schedule((Runnable)ActionRunnable.wrap((ActionListener)wrappedListener, l -> l.onResponse(response)), S3Repository.this.coolDown, "snapshot"));
                assert (existing == null) : "Already have an ongoing finalization " + S3Repository.access$300(S3Repository.this);
            }

            public void onFailure(Exception e) {
                S3Repository.this.logCooldownInfo();
                Scheduler.Cancellable existing = (Scheduler.Cancellable)S3Repository.this.finalizationFuture.getAndSet(S3Repository.this.threadPool.schedule((Runnable)ActionRunnable.wrap((ActionListener)wrappedListener, l -> l.onFailure(e)), S3Repository.this.coolDown, "snapshot"));
                assert (existing == null) : "Already have an ongoing finalization " + S3Repository.access$300(S3Repository.this);
            }
        };
    }

    private void logCooldownInfo() {
        logger.info("Sleeping for [{}] after modifying repository [{}] because it contains snapshots older than version [{}] and therefore is using a backwards compatible metadata format that requires this cooldown period to avoid repository corruption. To get rid of this message and move to the new repository metadata format, either remove all snapshots older than version [{}] from the repository or create a new repository at an empty location.", (Object)this.coolDown, (Object)this.metadata.name(), (Object)SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION, (Object)SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION);
    }

    protected S3BlobStore createBlobStore() {
        return new S3BlobStore(this.service, this.bucket, this.serverSideEncryption, this.bufferSize, this.cannedACL, this.storageClass, this.repositoryMetaData);
    }

    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    public BlobPath basePath() {
        return this.basePath;
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    protected void doClose() {
        Scheduler.Cancellable cancellable = this.finalizationFuture.getAndSet(null);
        if (cancellable != null) {
            logger.debug("Repository [{}] closed during cool-down period", (Object)this.metadata.name());
            cancellable.cancel();
        }
        super.doClose();
    }
}

