/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.util.json.Jackson;
import java.io.IOException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3Repository;
import org.elasticsearch.repositories.s3.S3Service;

public class S3RepositoryPlugin
extends Plugin
implements RepositoryPlugin,
ReloadablePlugin {
    protected final S3Service service;

    public S3RepositoryPlugin(Settings settings) {
        this(settings, new S3Service());
    }

    S3RepositoryPlugin(Settings settings, S3Service service) {
        this.service = Objects.requireNonNull(service, "S3 service must not be null");
        Map<String, S3ClientSettings> clientsSettings = S3ClientSettings.load(settings);
        this.service.refreshAndClearCache(clientsSettings);
    }

    protected S3Repository createRepository(RepositoryMetaData metadata, NamedXContentRegistry registry, ClusterService clusterService) {
        return new S3Repository(metadata, registry, this.service, clusterService);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry registry, ClusterService clusterService) {
        return Collections.singletonMap("s3", metadata -> this.createRepository(metadata, registry, clusterService));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(S3ClientSettings.ACCESS_KEY_SETTING, S3ClientSettings.SECRET_KEY_SETTING, S3ClientSettings.SESSION_TOKEN_SETTING, S3ClientSettings.ENDPOINT_SETTING, S3ClientSettings.PROTOCOL_SETTING, S3ClientSettings.PROXY_HOST_SETTING, S3ClientSettings.PROXY_PORT_SETTING, S3ClientSettings.PROXY_USERNAME_SETTING, S3ClientSettings.PROXY_PASSWORD_SETTING, S3ClientSettings.READ_TIMEOUT_SETTING, S3ClientSettings.MAX_RETRIES_SETTING, S3ClientSettings.USE_THROTTLE_RETRIES_SETTING, S3ClientSettings.USE_PATH_STYLE_ACCESS, S3Repository.ACCESS_KEY_SETTING, S3Repository.SECRET_KEY_SETTING);
    }

    public void reload(Settings settings) {
        Map<String, S3ClientSettings> clientsSettings = S3ClientSettings.load(settings);
        this.service.refreshAndClearCache(clientsSettings);
    }

    public void close() throws IOException {
        this.service.close();
    }

    static {
        SpecialPermission.check();
        AccessController.doPrivileged(() -> {
            try {
                Jackson.jsonNodeOf((String)"{}");
                Class.forName("com.amazonaws.ClientConfiguration");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }
}

