/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.s3.S3BlobStore;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3Service;
import org.elasticsearch.threadpool.ThreadPool;

class S3Repository
extends BlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(S3Repository.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
    static final String TYPE = "s3";
    static final Setting<SecureString> ACCESS_KEY_SETTING = SecureSetting.insecureString((String)"access_key");
    static final Setting<SecureString> SECRET_KEY_SETTING = SecureSetting.insecureString((String)"secret_key");
    private static final ByteSizeValue DEFAULT_BUFFER_SIZE = new ByteSizeValue(Math.max(ByteSizeUnit.MB.toBytes(5L), Math.min(ByteSizeUnit.MB.toBytes(100L), JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 20L)), ByteSizeUnit.BYTES);
    static final Setting<String> BUCKET_SETTING = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[0]);
    static final Setting<Boolean> SERVER_SIDE_ENCRYPTION_SETTING = Setting.boolSetting((String)"server_side_encryption", (boolean)false, (Setting.Property[])new Setting.Property[0]);
    static final ByteSizeValue MAX_FILE_SIZE = new ByteSizeValue(5L, ByteSizeUnit.GB);
    static final ByteSizeValue MIN_PART_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.MB);
    static final ByteSizeValue MAX_PART_SIZE_USING_MULTIPART = MAX_FILE_SIZE;
    static final ByteSizeValue MAX_FILE_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.TB);
    static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting((String)"buffer_size", (ByteSizeValue)DEFAULT_BUFFER_SIZE, (ByteSizeValue)MIN_PART_SIZE_USING_MULTIPART, (ByteSizeValue)MAX_PART_SIZE_USING_MULTIPART, (Setting.Property[])new Setting.Property[0]);
    static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.GB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.TB), (Setting.Property[])new Setting.Property[0]);
    static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting((String)"compress", (boolean)false, (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> STORAGE_CLASS_SETTING = Setting.simpleString((String)"storage_class", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> CANNED_ACL_SETTING = Setting.simpleString((String)"canned_acl", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> CLIENT_NAME = new Setting("client", "default", Function.identity(), new Setting.Property[0]);
    static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[0]);
    private final S3Service service;
    private final String bucket;
    private final ByteSizeValue bufferSize;
    private final ByteSizeValue chunkSize;
    private final BlobPath basePath;
    private final boolean serverSideEncryption;
    private final String storageClass;
    private final String cannedACL;
    private final RepositoryMetaData repositoryMetaData;

    S3Repository(RepositoryMetaData metadata, Settings settings, NamedXContentRegistry namedXContentRegistry, S3Service service, ThreadPool threadPool) {
        super(metadata, settings, ((Boolean)COMPRESS_SETTING.get(metadata.settings())).booleanValue(), namedXContentRegistry, threadPool);
        this.service = service;
        this.repositoryMetaData = metadata;
        this.bucket = (String)BUCKET_SETTING.get(metadata.settings());
        if (this.bucket == null) {
            throw new RepositoryException(metadata.name(), "No bucket defined for s3 repository");
        }
        this.bufferSize = (ByteSizeValue)BUFFER_SIZE_SETTING.get(metadata.settings());
        this.chunkSize = (ByteSizeValue)CHUNK_SIZE_SETTING.get(metadata.settings());
        if (this.chunkSize.getBytes() < this.bufferSize.getBytes()) {
            throw new RepositoryException(metadata.name(), CHUNK_SIZE_SETTING.getKey() + " (" + this.chunkSize + ") can't be lower than " + BUFFER_SIZE_SETTING.getKey() + " (" + this.bufferSize + ").");
        }
        String basePath = (String)BASE_PATH_SETTING.get(metadata.settings());
        this.basePath = Strings.hasLength((String)basePath) ? new BlobPath().add(basePath) : BlobPath.cleanPath();
        this.serverSideEncryption = (Boolean)SERVER_SIDE_ENCRYPTION_SETTING.get(metadata.settings());
        this.storageClass = (String)STORAGE_CLASS_SETTING.get(metadata.settings());
        this.cannedACL = (String)CANNED_ACL_SETTING.get(metadata.settings());
        if (S3ClientSettings.checkDeprecatedCredentials(metadata.settings())) {
            deprecationLogger.deprecated("Using s3 access/secret key from repository settings. Instead store these in named clients and the elasticsearch keystore for secure settings.", new Object[0]);
        }
        logger.debug("using bucket [{}], chunk_size [{}], server_side_encryption [{}], buffer_size [{}], cannedACL [{}], storageClass [{}]", (Object)this.bucket, (Object)this.chunkSize, (Object)this.serverSideEncryption, (Object)this.bufferSize, (Object)this.cannedACL, (Object)this.storageClass);
    }

    protected S3BlobStore createBlobStore() {
        return new S3BlobStore(this.service, this.bucket, this.serverSideEncryption, this.bufferSize, this.cannedACL, this.storageClass, this.repositoryMetaData);
    }

    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    public BlobPath basePath() {
        return this.basePath;
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }
}

