/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.util.AWSRequestMetrics;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.repositories.s3.AmazonS3Reference;
import org.elasticsearch.repositories.s3.S3BlobContainer;
import org.elasticsearch.repositories.s3.S3Service;

class S3BlobStore
implements BlobStore {
    private static final Logger logger = LogManager.getLogger(S3BlobStore.class);
    private final S3Service service;
    private final BigArrays bigArrays;
    private final String bucket;
    private final ByteSizeValue bufferSize;
    private final boolean serverSideEncryption;
    private final CannedAccessControlList cannedACL;
    private final StorageClass storageClass;
    private final RepositoryMetadata repositoryMetadata;
    private final Stats stats = new Stats();
    final RequestMetricCollector getMetricCollector;
    final RequestMetricCollector listMetricCollector;
    final RequestMetricCollector putMetricCollector;
    final RequestMetricCollector multiPartUploadMetricCollector;

    S3BlobStore(S3Service service, String bucket, boolean serverSideEncryption, ByteSizeValue bufferSize, String cannedACL, String storageClass, RepositoryMetadata repositoryMetadata, BigArrays bigArrays) {
        this.service = service;
        this.bigArrays = bigArrays;
        this.bucket = bucket;
        this.serverSideEncryption = serverSideEncryption;
        this.bufferSize = bufferSize;
        this.cannedACL = S3BlobStore.initCannedACL(cannedACL);
        this.storageClass = S3BlobStore.initStorageClass(storageClass);
        this.repositoryMetadata = repositoryMetadata;
        this.getMetricCollector = new IgnoreNoResponseMetricsCollector(){

            @Override
            public void collectMetrics(Request<?> request) {
                assert (request.getHttpMethod().name().equals("GET"));
                ((S3BlobStore)S3BlobStore.this).stats.getCount.addAndGet(S3BlobStore.this.getRequestCount(request));
            }
        };
        this.listMetricCollector = new IgnoreNoResponseMetricsCollector(){

            @Override
            public void collectMetrics(Request<?> request) {
                assert (request.getHttpMethod().name().equals("GET"));
                ((S3BlobStore)S3BlobStore.this).stats.listCount.addAndGet(S3BlobStore.this.getRequestCount(request));
            }
        };
        this.putMetricCollector = new IgnoreNoResponseMetricsCollector(){

            @Override
            public void collectMetrics(Request<?> request) {
                assert (request.getHttpMethod().name().equals("PUT"));
                ((S3BlobStore)S3BlobStore.this).stats.putCount.addAndGet(S3BlobStore.this.getRequestCount(request));
            }
        };
        this.multiPartUploadMetricCollector = new IgnoreNoResponseMetricsCollector(){

            @Override
            public void collectMetrics(Request<?> request) {
                assert (request.getHttpMethod().name().equals("PUT") || request.getHttpMethod().name().equals("POST"));
                ((S3BlobStore)S3BlobStore.this).stats.postCount.addAndGet(S3BlobStore.this.getRequestCount(request));
            }
        };
    }

    private long getRequestCount(Request<?> request) {
        Number requestCount = request.getAWSRequestMetrics().getTimingInfo().getCounter(AWSRequestMetrics.Field.RequestCount.name());
        if (requestCount == null) {
            logger.warn("Expected request count to be tracked for request [{}] but found not count.", request);
            return 0L;
        }
        return requestCount.longValue();
    }

    public String toString() {
        return this.bucket;
    }

    public AmazonS3Reference clientReference() {
        return this.service.client(this.repositoryMetadata);
    }

    int getMaxRetries() {
        return this.service.settings((RepositoryMetadata)this.repositoryMetadata).maxRetries;
    }

    public String bucket() {
        return this.bucket;
    }

    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    public boolean serverSideEncryption() {
        return this.serverSideEncryption;
    }

    public long bufferSizeInBytes() {
        return this.bufferSize.getBytes();
    }

    public BlobContainer blobContainer(BlobPath path) {
        return new S3BlobContainer(path, this);
    }

    public void close() throws IOException {
        this.service.close();
    }

    public Map<String, Long> stats() {
        return this.stats.toMap();
    }

    public CannedAccessControlList getCannedACL() {
        return this.cannedACL;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public static StorageClass initStorageClass(String storageClass) {
        if (storageClass == null || storageClass.equals("")) {
            return StorageClass.Standard;
        }
        try {
            StorageClass _storageClass = StorageClass.fromValue((String)storageClass.toUpperCase(Locale.ENGLISH));
            if (_storageClass.equals((Object)StorageClass.Glacier)) {
                throw new BlobStoreException("Glacier storage class is not supported");
            }
            return _storageClass;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BlobStoreException("`" + storageClass + "` is not a valid S3 Storage Class.");
        }
    }

    public static CannedAccessControlList initCannedACL(String cannedACL) {
        if (cannedACL == null || cannedACL.equals("")) {
            return CannedAccessControlList.Private;
        }
        for (CannedAccessControlList cur : CannedAccessControlList.values()) {
            if (!cur.toString().equalsIgnoreCase(cannedACL)) continue;
            return cur;
        }
        throw new BlobStoreException("cannedACL is not valid: [" + cannedACL + "]");
    }

    static class Stats {
        final AtomicLong listCount = new AtomicLong();
        final AtomicLong getCount = new AtomicLong();
        final AtomicLong putCount = new AtomicLong();
        final AtomicLong postCount = new AtomicLong();

        Stats() {
        }

        Map<String, Long> toMap() {
            HashMap<String, Long> results = new HashMap<String, Long>();
            results.put("GetObject", this.getCount.get());
            results.put("ListObjects", this.listCount.get());
            results.put("PutObject", this.putCount.get());
            results.put("PutMultipartObject", this.postCount.get());
            return results;
        }
    }

    private static abstract class IgnoreNoResponseMetricsCollector
    extends RequestMetricCollector {
        private IgnoreNoResponseMetricsCollector() {
        }

        public final void collectMetrics(Request<?> request, Response<?> response) {
            if (response != null) {
                this.collectMetrics(request);
            }
        }

        protected abstract void collectMetrics(Request<?> var1);
    }
}

