/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.s3.AmazonS3Reference;
import org.elasticsearch.repositories.s3.S3BasicCredentials;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3Repository;
import org.elasticsearch.repositories.s3.SocketAccess;

class S3Service
extends AbstractComponent
implements Closeable {
    private volatile Map<S3ClientSettings, AmazonS3Reference> clientsCache = Collections.emptyMap();
    private volatile Map<String, S3ClientSettings> staticClientSettings = MapBuilder.newMapBuilder().put((Object)"default", (Object)S3ClientSettings.getClientSettings(Settings.EMPTY, "default")).immutableMap();
    private volatile Map<S3ClientSettings, Map<RepositoryMetaData, S3ClientSettings>> derivedClientSettings = Collections.emptyMap();

    S3Service() {
    }

    public synchronized void refreshAndClearCache(Map<String, S3ClientSettings> clientsSettings) {
        this.releaseCachedClients();
        this.staticClientSettings = MapBuilder.newMapBuilder(clientsSettings).immutableMap();
        this.derivedClientSettings = Collections.emptyMap();
        assert (this.staticClientSettings.containsKey("default")) : "always at least have 'default'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonS3Reference client(RepositoryMetaData repositoryMetaData) {
        S3ClientSettings clientSettings = this.settings(repositoryMetaData);
        AmazonS3Reference clientReference = this.clientsCache.get(clientSettings);
        if (clientReference != null && clientReference.tryIncRef()) {
            return clientReference;
        }
        S3Service s3Service = this;
        synchronized (s3Service) {
            AmazonS3Reference existing = this.clientsCache.get(clientSettings);
            if (existing != null && existing.tryIncRef()) {
                return existing;
            }
            AmazonS3Reference clientReference2 = new AmazonS3Reference(this.buildClient(clientSettings));
            clientReference2.incRef();
            this.clientsCache = MapBuilder.newMapBuilder(this.clientsCache).put((Object)clientSettings, (Object)clientReference2).immutableMap();
            return clientReference2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3ClientSettings settings(RepositoryMetaData repositoryMetaData) {
        String clientName = (String)S3Repository.CLIENT_NAME.get(repositoryMetaData.settings());
        S3ClientSettings staticSettings = this.staticClientSettings.get(clientName);
        if (staticSettings != null) {
            S3ClientSettings existing = (S3ClientSettings)this.derivedClientSettings.getOrDefault(staticSettings, Collections.emptyMap()).get(repositoryMetaData);
            if (existing != null) {
                return existing;
            }
            S3Service s3Service = this;
            synchronized (s3Service) {
                Map derivedSettings = this.derivedClientSettings.getOrDefault(staticSettings, Collections.emptyMap());
                S3ClientSettings existing2 = (S3ClientSettings)derivedSettings.get(repositoryMetaData);
                if (existing2 != null) {
                    return existing2;
                }
                S3ClientSettings newSettings = staticSettings.refine(repositoryMetaData);
                this.derivedClientSettings = MapBuilder.newMapBuilder(this.derivedClientSettings).put((Object)staticSettings, (Object)MapBuilder.newMapBuilder(derivedSettings).put((Object)repositoryMetaData, (Object)newSettings).immutableMap()).immutableMap();
                return newSettings;
            }
        }
        throw new IllegalArgumentException("Unknown s3 client name [" + clientName + "]. Existing client configs: " + Strings.collectionToDelimitedString(this.staticClientSettings.keySet(), (String)","));
    }

    AmazonS3 buildClient(S3ClientSettings clientSettings) {
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        builder.withCredentials(S3Service.buildCredentials(this.logger, clientSettings));
        builder.withClientConfiguration(S3Service.buildConfiguration(clientSettings));
        String endpoint = Strings.hasLength((String)clientSettings.endpoint) ? clientSettings.endpoint : "s3.amazonaws.com";
        this.logger.debug("using endpoint [{}]", (Object)endpoint);
        builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, null));
        return (AmazonS3)builder.build();
    }

    static ClientConfiguration buildConfiguration(S3ClientSettings clientSettings) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol(clientSettings.protocol);
        if (Strings.hasText((String)clientSettings.proxyHost)) {
            clientConfiguration.setProxyHost(clientSettings.proxyHost);
            clientConfiguration.setProxyPort(clientSettings.proxyPort);
            clientConfiguration.setProxyUsername(clientSettings.proxyUsername);
            clientConfiguration.setProxyPassword(clientSettings.proxyPassword);
        }
        clientConfiguration.setMaxErrorRetry(clientSettings.maxRetries);
        clientConfiguration.setUseThrottleRetries(clientSettings.throttleRetries);
        clientConfiguration.setSocketTimeout(clientSettings.readTimeoutMillis);
        return clientConfiguration;
    }

    static AWSCredentialsProvider buildCredentials(Logger logger, S3ClientSettings clientSettings) {
        S3BasicCredentials credentials = clientSettings.credentials;
        if (credentials == null) {
            logger.debug("Using instance profile credentials");
            return new PrivilegedInstanceProfileCredentialsProvider();
        }
        logger.debug("Using basic key/secret credentials");
        return new AWSStaticCredentialsProvider((AWSCredentials)credentials);
    }

    private synchronized void releaseCachedClients() {
        for (AmazonS3Reference clientReference : this.clientsCache.values()) {
            clientReference.decRef();
        }
        this.clientsCache = Collections.emptyMap();
        IdleConnectionReaper.shutdown();
    }

    @Override
    public void close() throws IOException {
        this.releaseCachedClients();
    }

    static class PrivilegedInstanceProfileCredentialsProvider
    implements AWSCredentialsProvider {
        private final AWSCredentialsProvider credentials = new EC2ContainerCredentialsProviderWrapper();

        private PrivilegedInstanceProfileCredentialsProvider() {
        }

        public AWSCredentials getCredentials() {
            return SocketAccess.doPrivileged(() -> ((AWSCredentialsProvider)this.credentials).getCredentials());
        }

        public void refresh() {
            SocketAccess.doPrivilegedVoid(() -> ((AWSCredentialsProvider)this.credentials).refresh());
        }
    }
}

