/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.repositories.s3.AmazonS3Reference;
import org.elasticsearch.repositories.s3.S3BlobContainer;
import org.elasticsearch.repositories.s3.S3Service;
import org.elasticsearch.repositories.s3.SocketAccess;

class S3BlobStore
extends AbstractComponent
implements BlobStore {
    private final S3Service service;
    private final String clientName;
    private final String bucket;
    private final ByteSizeValue bufferSize;
    private final boolean serverSideEncryption;
    private final CannedAccessControlList cannedACL;
    private final StorageClass storageClass;

    S3BlobStore(S3Service service, String clientName, String bucket, boolean serverSideEncryption, ByteSizeValue bufferSize, String cannedACL, String storageClass) {
        this.service = service;
        this.clientName = clientName;
        this.bucket = bucket;
        this.serverSideEncryption = serverSideEncryption;
        this.bufferSize = bufferSize;
        this.cannedACL = S3BlobStore.initCannedACL(cannedACL);
        this.storageClass = S3BlobStore.initStorageClass(storageClass);
    }

    public String toString() {
        return this.bucket;
    }

    public AmazonS3Reference clientReference() {
        return this.service.client(this.clientName);
    }

    public String bucket() {
        return this.bucket;
    }

    public boolean serverSideEncryption() {
        return this.serverSideEncryption;
    }

    public long bufferSizeInBytes() {
        return this.bufferSize.getBytes();
    }

    public BlobContainer blobContainer(BlobPath path) {
        return new S3BlobContainer(path, this);
    }

    public void delete(BlobPath path) {
        try (AmazonS3Reference clientReference = this.clientReference();){
            ObjectListing prevListing = null;
            DeleteObjectsRequest multiObjectDeleteRequest = null;
            ArrayList<DeleteObjectsRequest.KeyVersion> keys = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            while (true) {
                ObjectListing list;
                if (prevListing != null) {
                    ObjectListing finalPrevListing = prevListing;
                    list = SocketAccess.doPrivileged(() -> clientReference.client().listNextBatchOfObjects(finalPrevListing));
                } else {
                    list = SocketAccess.doPrivileged(() -> clientReference.client().listObjects(this.bucket, path.buildAsString()));
                    multiObjectDeleteRequest = new DeleteObjectsRequest(list.getBucketName());
                }
                for (S3ObjectSummary summary : list.getObjectSummaries()) {
                    keys.add(new DeleteObjectsRequest.KeyVersion(summary.getKey()));
                    if (keys.size() <= 500) continue;
                    multiObjectDeleteRequest.setKeys(keys);
                    DeleteObjectsRequest finalMultiObjectDeleteRequest = multiObjectDeleteRequest;
                    SocketAccess.doPrivilegedVoid(() -> clientReference.client().deleteObjects(finalMultiObjectDeleteRequest));
                    multiObjectDeleteRequest = new DeleteObjectsRequest(list.getBucketName());
                    keys.clear();
                }
                if (!list.isTruncated()) break;
                prevListing = list;
            }
            if (!keys.isEmpty()) {
                multiObjectDeleteRequest.setKeys(keys);
                DeleteObjectsRequest finalMultiObjectDeleteRequest = multiObjectDeleteRequest;
                SocketAccess.doPrivilegedVoid(() -> clientReference.client().deleteObjects(finalMultiObjectDeleteRequest));
            }
        }
    }

    public void close() throws IOException {
        this.service.close();
    }

    public CannedAccessControlList getCannedACL() {
        return this.cannedACL;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public static StorageClass initStorageClass(String storageClass) {
        if (storageClass == null || storageClass.equals("")) {
            return StorageClass.Standard;
        }
        try {
            StorageClass _storageClass = StorageClass.fromValue((String)storageClass.toUpperCase(Locale.ENGLISH));
            if (_storageClass.equals((Object)StorageClass.Glacier)) {
                throw new BlobStoreException("Glacier storage class is not supported");
            }
            return _storageClass;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BlobStoreException("`" + storageClass + "` is not a valid S3 Storage Class.");
        }
    }

    public static CannedAccessControlList initCannedACL(String cannedACL) {
        if (cannedACL == null || cannedACL.equals("")) {
            return CannedAccessControlList.Private;
        }
        for (CannedAccessControlList cur : CannedAccessControlList.values()) {
            if (!cur.toString().equalsIgnoreCase(cannedACL)) continue;
            return cur;
        }
        throw new BlobStoreException("cannedACL is not valid: [" + cannedACL + "]");
    }
}

