/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import java.util.function.Function;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.s3.AmazonS3Reference;
import org.elasticsearch.repositories.s3.S3BlobStore;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3Service;

class S3Repository
extends BlobStoreRepository {
    static final String TYPE = "s3";
    static final Setting<SecureString> ACCESS_KEY_SETTING = SecureSetting.insecureString((String)"access_key");
    static final Setting<SecureString> SECRET_KEY_SETTING = SecureSetting.insecureString((String)"secret_key");
    private static final ByteSizeValue DEFAULT_BUFFER_SIZE = new ByteSizeValue(Math.max(ByteSizeUnit.MB.toBytes(5L), Math.min(ByteSizeUnit.MB.toBytes(100L), JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 20L)), ByteSizeUnit.BYTES);
    static final Setting<String> BUCKET_SETTING = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[0]);
    static final Setting<Boolean> SERVER_SIDE_ENCRYPTION_SETTING = Setting.boolSetting((String)"server_side_encryption", (boolean)false, (Setting.Property[])new Setting.Property[0]);
    static final ByteSizeValue MAX_FILE_SIZE = new ByteSizeValue(5L, ByteSizeUnit.GB);
    static final ByteSizeValue MIN_PART_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.MB);
    static final ByteSizeValue MAX_PART_SIZE_USING_MULTIPART = MAX_FILE_SIZE;
    static final ByteSizeValue MAX_FILE_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.TB);
    static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting((String)"buffer_size", (ByteSizeValue)DEFAULT_BUFFER_SIZE, (ByteSizeValue)MIN_PART_SIZE_USING_MULTIPART, (ByteSizeValue)MAX_PART_SIZE_USING_MULTIPART, (Setting.Property[])new Setting.Property[0]);
    static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.GB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.TB), (Setting.Property[])new Setting.Property[0]);
    static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting((String)"compress", (boolean)false, (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> STORAGE_CLASS_SETTING = Setting.simpleString((String)"storage_class", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> CANNED_ACL_SETTING = Setting.simpleString((String)"canned_acl", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> CLIENT_NAME = new Setting("client", "default", Function.identity(), new Setting.Property[0]);
    static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[0]);
    private final S3Service service;
    private final String bucket;
    private final ByteSizeValue bufferSize;
    private final ByteSizeValue chunkSize;
    private final boolean compress;
    private final BlobPath basePath;
    private final boolean serverSideEncryption;
    private final String storageClass;
    private final String cannedACL;
    private final String clientName;
    private final AmazonS3Reference reference;

    S3Repository(RepositoryMetaData metadata, Settings settings, NamedXContentRegistry namedXContentRegistry, S3Service service) {
        super(metadata, settings, namedXContentRegistry);
        this.service = service;
        this.bucket = (String)BUCKET_SETTING.get(metadata.settings());
        if (this.bucket == null) {
            throw new RepositoryException(metadata.name(), "No bucket defined for s3 repository");
        }
        this.bufferSize = (ByteSizeValue)BUFFER_SIZE_SETTING.get(metadata.settings());
        this.chunkSize = (ByteSizeValue)CHUNK_SIZE_SETTING.get(metadata.settings());
        this.compress = (Boolean)COMPRESS_SETTING.get(metadata.settings());
        if (this.chunkSize.getBytes() < this.bufferSize.getBytes()) {
            throw new RepositoryException(metadata.name(), CHUNK_SIZE_SETTING.getKey() + " (" + this.chunkSize + ") can't be lower than " + BUFFER_SIZE_SETTING.getKey() + " (" + this.bufferSize + ").");
        }
        String basePath = (String)BASE_PATH_SETTING.get(metadata.settings());
        this.basePath = Strings.hasLength((String)basePath) ? new BlobPath().add(basePath) : BlobPath.cleanPath();
        this.serverSideEncryption = (Boolean)SERVER_SIDE_ENCRYPTION_SETTING.get(metadata.settings());
        this.storageClass = (String)STORAGE_CLASS_SETTING.get(metadata.settings());
        this.cannedACL = (String)CANNED_ACL_SETTING.get(metadata.settings());
        this.clientName = (String)CLIENT_NAME.get(metadata.settings());
        if (CLIENT_NAME.exists(metadata.settings()) && S3ClientSettings.checkDeprecatedCredentials(metadata.settings())) {
            this.logger.warn("ignoring use of named client [{}] for repository [{}] as insecure credentials were specified", (Object)this.clientName, (Object)metadata.name());
        }
        if (S3ClientSettings.checkDeprecatedCredentials(metadata.settings())) {
            this.deprecationLogger.deprecated("Using s3 access/secret key from repository settings. Instead store these in named clients and the elasticsearch keystore for secure settings.", new Object[0]);
            BasicAWSCredentials insecureCredentials = S3ClientSettings.loadDeprecatedCredentials(metadata.settings());
            S3ClientSettings s3ClientSettings = S3ClientSettings.getClientSettings(metadata, (AWSCredentials)insecureCredentials);
            this.reference = new AmazonS3Reference(service.buildClient(S3Service.buildCredentials(this.logger, s3ClientSettings), S3Service.buildConfiguration(s3ClientSettings)));
        } else {
            this.reference = null;
        }
        this.logger.debug("using bucket [{}], chunk_size [{}], server_side_encryption [{}], buffer_size [{}], cannedACL [{}], storageClass [{}]", (Object)this.bucket, (Object)this.chunkSize, (Object)this.serverSideEncryption, (Object)this.bufferSize, (Object)this.cannedACL, (Object)this.storageClass);
    }

    protected S3BlobStore createBlobStore() {
        if (this.reference != null) {
            assert (S3ClientSettings.checkDeprecatedCredentials(this.metadata.settings())) : this.metadata.name();
            return new S3BlobStore(this.settings, this.service, this.clientName, this.bucket, this.serverSideEncryption, this.bufferSize, this.cannedACL, this.storageClass){

                @Override
                public AmazonS3Reference clientReference() {
                    if (S3Repository.this.reference.tryIncRef()) {
                        return S3Repository.this.reference;
                    }
                    throw new IllegalStateException("S3 client is closed");
                }
            };
        }
        return new S3BlobStore(this.settings, this.service, this.clientName, this.bucket, this.serverSideEncryption, this.bufferSize, this.cannedACL, this.storageClass);
    }

    protected BlobStore blobStore() {
        return super.blobStore();
    }

    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    protected BlobPath basePath() {
        return this.basePath;
    }

    protected boolean isCompress() {
        return this.compress;
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    protected void doClose() {
        if (this.reference != null) {
            assert (S3ClientSettings.checkDeprecatedCredentials(this.metadata.settings())) : this.metadata.name();
            this.reference.decRef();
        }
        super.doClose();
    }
}

