/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.s3.AmazonS3Reference;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.SocketAccess;

class S3Service
extends AbstractComponent
implements Closeable {
    private volatile Map<String, AmazonS3Reference> clientsCache = Collections.emptyMap();
    private volatile Map<String, S3ClientSettings> clientsSettings = Collections.emptyMap();

    S3Service(Settings settings) {
        super(settings);
    }

    public synchronized Map<String, S3ClientSettings> refreshAndClearCache(Map<String, S3ClientSettings> clientsSettings) {
        this.releaseCachedClients();
        Map<String, S3ClientSettings> prevSettings = this.clientsSettings;
        this.clientsSettings = MapBuilder.newMapBuilder(clientsSettings).immutableMap();
        assert (this.clientsSettings.containsKey("default")) : "always at least have 'default'";
        return prevSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonS3Reference client(String clientName) {
        AmazonS3Reference clientReference = this.clientsCache.get(clientName);
        if (clientReference != null && clientReference.tryIncRef()) {
            return clientReference;
        }
        S3Service s3Service = this;
        synchronized (s3Service) {
            clientReference = this.clientsCache.get(clientName);
            if (clientReference != null && clientReference.tryIncRef()) {
                return clientReference;
            }
            S3ClientSettings clientSettings = this.clientsSettings.get(clientName);
            if (clientSettings == null) {
                throw new IllegalArgumentException("Unknown s3 client name [" + clientName + "]. Existing client configs: " + Strings.collectionToDelimitedString(this.clientsSettings.keySet(), (String)","));
            }
            this.logger.debug("creating S3 client with client_name [{}], endpoint [{}]", (Object)clientName, (Object)clientSettings.endpoint);
            clientReference = new AmazonS3Reference(this.buildClient(clientSettings));
            clientReference.incRef();
            this.clientsCache = MapBuilder.newMapBuilder(this.clientsCache).put((Object)clientName, (Object)clientReference).immutableMap();
            return clientReference;
        }
    }

    private AmazonS3 buildClient(S3ClientSettings clientSettings) {
        AWSCredentialsProvider credentials = S3Service.buildCredentials(this.logger, clientSettings);
        ClientConfiguration configuration = S3Service.buildConfiguration(clientSettings);
        AmazonS3 client = this.buildClient(credentials, configuration);
        if (Strings.hasText((String)clientSettings.endpoint)) {
            client.setEndpoint(clientSettings.endpoint);
        }
        return client;
    }

    AmazonS3 buildClient(AWSCredentialsProvider credentials, ClientConfiguration configuration) {
        return new AmazonS3Client(credentials, configuration);
    }

    static ClientConfiguration buildConfiguration(S3ClientSettings clientSettings) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol(clientSettings.protocol);
        if (Strings.hasText((String)clientSettings.proxyHost)) {
            clientConfiguration.setProxyHost(clientSettings.proxyHost);
            clientConfiguration.setProxyPort(clientSettings.proxyPort);
            clientConfiguration.setProxyUsername(clientSettings.proxyUsername);
            clientConfiguration.setProxyPassword(clientSettings.proxyPassword);
        }
        clientConfiguration.setMaxErrorRetry(clientSettings.maxRetries);
        clientConfiguration.setUseThrottleRetries(clientSettings.throttleRetries);
        clientConfiguration.setSocketTimeout(clientSettings.readTimeoutMillis);
        return clientConfiguration;
    }

    static AWSCredentialsProvider buildCredentials(Logger logger, S3ClientSettings clientSettings) {
        AWSCredentials credentials = clientSettings.credentials;
        if (credentials == null) {
            logger.debug("Using instance profile credentials");
            return new PrivilegedInstanceProfileCredentialsProvider();
        }
        logger.debug("Using basic key/secret credentials");
        return new StaticCredentialsProvider(credentials);
    }

    private static <T> T getRepoValue(Settings repositorySettings, Setting<T> repositorySetting, T fallback) {
        if (repositorySetting.exists(repositorySettings)) {
            return (T)repositorySetting.get(repositorySettings);
        }
        return fallback;
    }

    protected synchronized void releaseCachedClients() {
        for (AmazonS3Reference clientReference : this.clientsCache.values()) {
            clientReference.decRef();
        }
        this.clientsCache = Collections.emptyMap();
        IdleConnectionReaper.shutdown();
    }

    @Override
    public void close() throws IOException {
        this.releaseCachedClients();
    }

    static class PrivilegedInstanceProfileCredentialsProvider
    implements AWSCredentialsProvider {
        private final AWSCredentialsProvider credentials = new EC2ContainerCredentialsProviderWrapper();

        private PrivilegedInstanceProfileCredentialsProvider() {
        }

        public AWSCredentials getCredentials() {
            return SocketAccess.doPrivileged(() -> ((AWSCredentialsProvider)this.credentials).getCredentials());
        }

        public void refresh() {
            SocketAccess.doPrivilegedVoid(() -> ((AWSCredentialsProvider)this.credentials).refresh());
        }
    }
}

