/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.util.json.Jackson;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.s3.AwsS3Service;
import org.elasticsearch.repositories.s3.InternalAwsS3Service;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3Repository;

public class S3RepositoryPlugin
extends Plugin
implements RepositoryPlugin {
    private final Map<String, S3ClientSettings> clientsSettings;

    public S3RepositoryPlugin(Settings settings) {
        this.clientsSettings = S3ClientSettings.load(settings);
        assert (!this.clientsSettings.isEmpty()) : "always at least have 'default'";
    }

    protected AwsS3Service createStorageService(Settings settings) {
        return new InternalAwsS3Service(settings, this.clientsSettings);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry) {
        return Collections.singletonMap("s3", metadata -> new S3Repository(metadata, env.settings(), namedXContentRegistry, this.createStorageService(env.settings())));
    }

    public List<String> getSettingsFilter() {
        return Arrays.asList(S3Repository.Repository.KEY_SETTING.getKey(), S3Repository.Repository.SECRET_SETTING.getKey());
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(S3ClientSettings.ACCESS_KEY_SETTING, S3ClientSettings.SECRET_KEY_SETTING, S3ClientSettings.ENDPOINT_SETTING, S3ClientSettings.PROTOCOL_SETTING, S3ClientSettings.PROXY_HOST_SETTING, S3ClientSettings.PROXY_PORT_SETTING, S3ClientSettings.PROXY_USERNAME_SETTING, S3ClientSettings.PROXY_PASSWORD_SETTING, S3ClientSettings.READ_TIMEOUT_SETTING, S3ClientSettings.MAX_RETRIES_SETTING, S3ClientSettings.USE_THROTTLE_RETRIES_SETTING, AwsS3Service.KEY_SETTING, AwsS3Service.SECRET_SETTING, AwsS3Service.PROTOCOL_SETTING, AwsS3Service.PROXY_HOST_SETTING, AwsS3Service.PROXY_PORT_SETTING, AwsS3Service.PROXY_USERNAME_SETTING, AwsS3Service.PROXY_PASSWORD_SETTING, AwsS3Service.SIGNER_SETTING, AwsS3Service.REGION_SETTING, AwsS3Service.READ_TIMEOUT, AwsS3Service.CLOUD_S3.KEY_SETTING, AwsS3Service.CLOUD_S3.SECRET_SETTING, AwsS3Service.CLOUD_S3.PROTOCOL_SETTING, AwsS3Service.CLOUD_S3.PROXY_HOST_SETTING, AwsS3Service.CLOUD_S3.PROXY_PORT_SETTING, AwsS3Service.CLOUD_S3.PROXY_USERNAME_SETTING, AwsS3Service.CLOUD_S3.PROXY_PASSWORD_SETTING, AwsS3Service.CLOUD_S3.SIGNER_SETTING, AwsS3Service.CLOUD_S3.REGION_SETTING, AwsS3Service.CLOUD_S3.ENDPOINT_SETTING, AwsS3Service.CLOUD_S3.READ_TIMEOUT, S3Repository.Repositories.KEY_SETTING, S3Repository.Repositories.SECRET_SETTING, S3Repository.Repositories.BUCKET_SETTING, S3Repository.Repositories.REGION_SETTING, S3Repository.Repositories.ENDPOINT_SETTING, S3Repository.Repositories.PROTOCOL_SETTING, S3Repository.Repositories.SERVER_SIDE_ENCRYPTION_SETTING, S3Repository.Repositories.BUFFER_SIZE_SETTING, S3Repository.Repositories.MAX_RETRIES_SETTING, S3Repository.Repositories.CHUNK_SIZE_SETTING, S3Repository.Repositories.COMPRESS_SETTING, S3Repository.Repositories.STORAGE_CLASS_SETTING, S3Repository.Repositories.CANNED_ACL_SETTING, S3Repository.Repositories.BASE_PATH_SETTING, S3Repository.Repositories.USE_THROTTLE_RETRIES_SETTING, S3Repository.Repositories.PATH_STYLE_ACCESS_SETTING);
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Jackson.jsonNodeOf((String)"{}");
                    Class.forName("com.amazonaws.ClientConfiguration");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }
}

