/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.repositories.s3.S3BlobStore;

abstract class S3OutputStream
extends OutputStream {
    protected static final ByteSizeValue MULTIPART_MAX_SIZE = new ByteSizeValue(5L, ByteSizeUnit.GB);
    protected static final ByteSizeValue MULTIPART_MIN_SIZE = new ByteSizeValue(5L, ByteSizeUnit.MB);
    private S3BlobStore blobStore;
    private String bucketName;
    private String blobName;
    private boolean serverSideEncryption;
    private byte[] buffer;
    private int count;
    private long length;
    private int flushCount = 0;

    S3OutputStream(S3BlobStore blobStore, String bucketName, String blobName, int bufferSizeInBytes, boolean serverSideEncryption) {
        this.blobStore = blobStore;
        this.bucketName = bucketName;
        this.blobName = blobName;
        this.serverSideEncryption = serverSideEncryption;
        if ((long)bufferSizeInBytes < MULTIPART_MIN_SIZE.getBytes()) {
            throw new IllegalArgumentException("Buffer size can't be smaller than " + MULTIPART_MIN_SIZE);
        }
        if ((long)bufferSizeInBytes > MULTIPART_MAX_SIZE.getBytes()) {
            throw new IllegalArgumentException("Buffer size can't be larger than " + MULTIPART_MAX_SIZE);
        }
        this.buffer = new byte[bufferSizeInBytes];
    }

    public abstract void flush(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    private void flushBuffer(boolean closing) throws IOException {
        this.flush(this.buffer, 0, this.count, closing);
        ++this.flushCount;
        this.count = 0;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count >= this.buffer.length) {
            this.flushBuffer(false);
        }
        this.buffer[this.count++] = (byte)b;
        ++this.length;
    }

    @Override
    public void close() throws IOException {
        if (this.count > 0) {
            this.flushBuffer(true);
            this.count = 0;
        }
    }

    public S3BlobStore getBlobStore() {
        return this.blobStore;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getBlobName() {
        return this.blobName;
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public boolean isServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public long getLength() {
        return this.length;
    }

    public int getFlushCount() {
        return this.flushCount;
    }
}

