/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.repositories.s3.S3BlobStore;
import org.elasticsearch.repositories.s3.S3OutputStream;

class DefaultS3OutputStream
extends S3OutputStream {
    private static final ByteSizeValue MULTIPART_MAX_SIZE = new ByteSizeValue(5L, ByteSizeUnit.GB);
    private static final Logger logger = Loggers.getLogger((String)"cloud.aws");
    private String multipartId;
    private int multipartChunks;
    private List<PartETag> multiparts;

    DefaultS3OutputStream(S3BlobStore blobStore, String bucketName, String blobName, int bufferSizeInBytes, boolean serverSideEncryption) {
        super(blobStore, bucketName, blobName, bufferSizeInBytes, serverSideEncryption);
    }

    @Override
    public void flush(byte[] bytes, int off, int len, boolean closing) throws IOException {
        if ((long)len > MULTIPART_MAX_SIZE.getBytes()) {
            throw new IOException("Unable to upload files larger than " + MULTIPART_MAX_SIZE + " to Amazon S3");
        }
        if (!closing) {
            if (len < this.getBufferSize()) {
                this.upload(bytes, off, len);
            } else {
                if (this.getFlushCount() == 0) {
                    this.initializeMultipart();
                }
                this.uploadMultipart(bytes, off, len, false);
            }
        } else if (this.multipartId != null) {
            this.uploadMultipart(bytes, off, len, true);
            this.completeMultipart();
        } else {
            this.upload(bytes, off, len);
        }
    }

    private void upload(byte[] bytes, int off, int len) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes, off, len);){
            try {
                this.doUpload(this.getBlobStore(), this.getBucketName(), this.getBlobName(), is, len, this.isServerSideEncryption());
            }
            catch (AmazonClientException e) {
                throw new IOException("Unable to upload object " + this.getBlobName(), e);
            }
        }
    }

    protected void doUpload(S3BlobStore blobStore, String bucketName, String blobName, InputStream is, int length, boolean serverSideEncryption) throws AmazonS3Exception {
        ObjectMetadata md = new ObjectMetadata();
        if (serverSideEncryption) {
            md.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        }
        md.setContentLength((long)length);
        PutObjectRequest putRequest = new PutObjectRequest(bucketName, blobName, is, md).withStorageClass(blobStore.getStorageClass()).withCannedAcl(blobStore.getCannedACL());
        blobStore.client().putObject(putRequest);
    }

    private void initializeMultipart() {
        while (this.multipartId == null) {
            this.multipartId = this.doInitialize(this.getBlobStore(), this.getBucketName(), this.getBlobName(), this.isServerSideEncryption());
            if (this.multipartId == null) continue;
            this.multipartChunks = 1;
            this.multiparts = new ArrayList<PartETag>();
        }
    }

    protected String doInitialize(S3BlobStore blobStore, String bucketName, String blobName, boolean serverSideEncryption) {
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(bucketName, blobName).withCannedACL(blobStore.getCannedACL()).withStorageClass(blobStore.getStorageClass());
        if (serverSideEncryption) {
            ObjectMetadata md = new ObjectMetadata();
            md.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
            request.setObjectMetadata(md);
        }
        return blobStore.client().initiateMultipartUpload(request).getUploadId();
    }

    private void uploadMultipart(byte[] bytes, int off, int len, boolean lastPart) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes, off, len);){
            try {
                PartETag partETag = this.doUploadMultipart(this.getBlobStore(), this.getBucketName(), this.getBlobName(), this.multipartId, is, len, lastPart);
                this.multiparts.add(partETag);
                ++this.multipartChunks;
            }
            catch (AmazonClientException e) {
                this.abortMultipart();
                throw e;
            }
        }
    }

    protected PartETag doUploadMultipart(S3BlobStore blobStore, String bucketName, String blobName, String uploadId, InputStream is, int length, boolean lastPart) throws AmazonS3Exception {
        UploadPartRequest request = new UploadPartRequest().withBucketName(bucketName).withKey(blobName).withUploadId(uploadId).withPartNumber(this.multipartChunks).withInputStream(is).withPartSize((long)length).withLastPart(lastPart);
        UploadPartResult response = blobStore.client().uploadPart(request);
        return response.getPartETag();
    }

    private void completeMultipart() {
        try {
            this.doCompleteMultipart(this.getBlobStore(), this.getBucketName(), this.getBlobName(), this.multipartId, this.multiparts);
            this.multipartId = null;
            return;
        }
        catch (AmazonClientException e) {
            this.abortMultipart();
            throw e;
        }
    }

    protected void doCompleteMultipart(S3BlobStore blobStore, String bucketName, String blobName, String uploadId, List<PartETag> parts) throws AmazonS3Exception {
        CompleteMultipartUploadRequest request = new CompleteMultipartUploadRequest(bucketName, blobName, uploadId, parts);
        blobStore.client().completeMultipartUpload(request);
    }

    private void abortMultipart() {
        if (this.multipartId != null) {
            try {
                this.doAbortMultipart(this.getBlobStore(), this.getBucketName(), this.getBlobName(), this.multipartId);
            }
            finally {
                this.multipartId = null;
            }
        }
    }

    protected void doAbortMultipart(S3BlobStore blobStore, String bucketName, String blobName, String uploadId) throws AmazonS3Exception {
        blobStore.client().abortMultipartUpload(new AbortMultipartUploadRequest(bucketName, blobName, uploadId));
    }
}

