/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.Protocol;
import com.amazonaws.auth.BasicAWSCredentials;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.repositories.s3.AwsS3Service;
import org.elasticsearch.repositories.s3.S3Repository;

class S3ClientSettings {
    private static final String PREFIX = "s3.client.";
    static final Setting.AffixSetting<SecureString> ACCESS_KEY_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"access_key", key -> SecureSetting.secureString((String)key, S3Repository.Repositories.KEY_SETTING, (Setting.Property[])new Setting.Property[0]));
    static final Setting.AffixSetting<SecureString> SECRET_KEY_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"secret_key", key -> SecureSetting.secureString((String)key, S3Repository.Repositories.SECRET_SETTING, (Setting.Property[])new Setting.Property[0]));
    static final Setting.AffixSetting<String> ENDPOINT_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"endpoint", key -> new Setting(key, S3Repository.Repositories.ENDPOINT_SETTING, s -> s.toLowerCase(Locale.ROOT), new Setting.Property[]{Setting.Property.NodeScope}));
    static final Setting.AffixSetting<Protocol> PROTOCOL_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"protocol", key -> new Setting(key, "https", s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope}));
    static final Setting.AffixSetting<String> PROXY_HOST_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"proxy.host", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    static final Setting.AffixSetting<Integer> PROXY_PORT_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"proxy.port", key -> Setting.intSetting((String)key, (int)80, (int)0, (int)65536, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    static final Setting.AffixSetting<SecureString> PROXY_USERNAME_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"proxy.username", key -> SecureSetting.secureString((String)key, AwsS3Service.PROXY_USERNAME_SETTING, (Setting.Property[])new Setting.Property[0]));
    static final Setting.AffixSetting<SecureString> PROXY_PASSWORD_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"proxy.password", key -> SecureSetting.secureString((String)key, AwsS3Service.PROXY_PASSWORD_SETTING, (Setting.Property[])new Setting.Property[0]));
    static final Setting.AffixSetting<TimeValue> READ_TIMEOUT_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueMillis((long)50000L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    final BasicAWSCredentials credentials;
    final String endpoint;
    final String region;
    final Protocol protocol;
    final String proxyHost;
    final int proxyPort;
    final String proxyUsername;
    final String proxyPassword;
    final String awsSigner;
    final int readTimeoutMillis;

    private S3ClientSettings(BasicAWSCredentials credentials, String endpoint, String region, Protocol protocol, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, String awsSigner, int readTimeoutMillis) {
        this.credentials = credentials;
        this.region = region;
        this.endpoint = endpoint;
        this.protocol = protocol;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.awsSigner = awsSigner;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    static Map<String, S3ClientSettings> load(Settings settings) {
        Set clientNames = settings.getGroups(PREFIX).keySet();
        HashMap<String, S3ClientSettings> clients = new HashMap<String, S3ClientSettings>();
        for (String clientName : clientNames) {
            clients.put(clientName, S3ClientSettings.getClientSettings(settings, clientName));
        }
        if (!clients.containsKey("default")) {
            clients.put("default", S3ClientSettings.getClientSettings(settings, "default"));
        }
        return Collections.unmodifiableMap(clients);
    }

    /*
     * Exception decompiling
     */
    static S3ClientSettings getClientSettings(Settings settings, String clientName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <T> T getConfigValue(Settings settings, String clientName, Setting.AffixSetting<T> clientSetting, Setting<T> globalSetting) {
        Setting concreteSetting = clientSetting.getConcreteSettingForNamespace(clientName);
        if (concreteSetting.exists(settings)) {
            return (T)concreteSetting.get(settings);
        }
        return (T)globalSetting.get(settings);
    }
}

