/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.s3.AwsS3Service;
import org.elasticsearch.repositories.s3.AwsSigner;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3Repository;

class InternalAwsS3Service
extends AbstractLifecycleComponent
implements AwsS3Service {
    static final Setting<String> CLIENT_NAME = new Setting("client", "default", Function.identity(), new Setting.Property[0]);
    private final Map<String, S3ClientSettings> clientsSettings;
    private final Map<String, AmazonS3Client> clientsCache = new HashMap<String, AmazonS3Client>();

    InternalAwsS3Service(Settings settings, Map<String, S3ClientSettings> clientsSettings) {
        super(settings);
        this.clientsSettings = clientsSettings;
    }

    @Override
    public synchronized AmazonS3 client(Settings repositorySettings) {
        String clientName = (String)CLIENT_NAME.get(repositorySettings);
        AmazonS3Client client = this.clientsCache.get(clientName);
        if (client != null) {
            return client;
        }
        S3ClientSettings clientSettings = this.clientsSettings.get(clientName);
        if (clientSettings == null) {
            throw new IllegalArgumentException("Unknown s3 client name [" + clientName + "]. Existing client configs: " + Strings.collectionToDelimitedString(this.clientsSettings.keySet(), (String)","));
        }
        String endpoint = InternalAwsS3Service.findEndpoint(this.logger, this.deprecationLogger, clientSettings, repositorySettings);
        Integer maxRetries = S3Repository.getValue(repositorySettings, this.settings, S3Repository.Repository.MAX_RETRIES_SETTING, S3Repository.Repositories.MAX_RETRIES_SETTING);
        boolean useThrottleRetries = S3Repository.getValue(repositorySettings, this.settings, S3Repository.Repository.USE_THROTTLE_RETRIES_SETTING, S3Repository.Repositories.USE_THROTTLE_RETRIES_SETTING);
        Boolean pathStyleAccess = null;
        if (S3Repository.Repository.PATH_STYLE_ACCESS_SETTING.exists(repositorySettings) || S3Repository.Repositories.PATH_STYLE_ACCESS_SETTING.exists(this.settings)) {
            pathStyleAccess = S3Repository.getValue(repositorySettings, this.settings, S3Repository.Repository.PATH_STYLE_ACCESS_SETTING, S3Repository.Repositories.PATH_STYLE_ACCESS_SETTING);
        }
        this.logger.debug("creating S3 client with client_name [{}], endpoint [{}], max_retries [{}], use_throttle_retries [{}], path_style_access [{}]", (Object)clientName, (Object)endpoint, (Object)maxRetries, (Object)useThrottleRetries, (Object)pathStyleAccess);
        AWSCredentialsProvider credentials = InternalAwsS3Service.buildCredentials(this.logger, this.deprecationLogger, clientSettings, repositorySettings);
        ClientConfiguration configuration = InternalAwsS3Service.buildConfiguration(this.logger, clientSettings, repositorySettings, maxRetries, endpoint, useThrottleRetries);
        client = new AmazonS3Client(credentials, configuration);
        if (pathStyleAccess != null) {
            client.setS3ClientOptions(new S3ClientOptions().withPathStyleAccess(pathStyleAccess.booleanValue()));
        }
        if (Strings.hasText((String)endpoint)) {
            client.setEndpoint(endpoint);
        }
        this.clientsCache.put(clientName, client);
        return client;
    }

    static ClientConfiguration buildConfiguration(Logger logger, S3ClientSettings clientSettings, Settings repositorySettings, Integer maxRetries, String endpoint, boolean useThrottleRetries) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        Protocol protocol = InternalAwsS3Service.getRepoValue(repositorySettings, S3Repository.Repository.PROTOCOL_SETTING, clientSettings.protocol);
        clientConfiguration.setProtocol(protocol);
        if (Strings.hasText((String)clientSettings.proxyHost)) {
            clientConfiguration.setProxyHost(clientSettings.proxyHost);
            clientConfiguration.setProxyPort(clientSettings.proxyPort);
            clientConfiguration.setProxyUsername(clientSettings.proxyUsername);
            clientConfiguration.setProxyPassword(clientSettings.proxyPassword);
        }
        if (maxRetries != null) {
            clientConfiguration.setMaxErrorRetry(maxRetries.intValue());
        }
        clientConfiguration.setUseThrottleRetries(useThrottleRetries);
        if (Strings.hasText((String)clientSettings.awsSigner)) {
            logger.debug("using AWS API signer [{}]", (Object)clientSettings.awsSigner);
            AwsSigner.configureSigner(clientSettings.awsSigner, clientConfiguration, endpoint);
        }
        clientConfiguration.setSocketTimeout(clientSettings.readTimeoutMillis);
        return clientConfiguration;
    }

    private static AWSCredentials getDeprecatedCredentials(Logger logger, DeprecationLogger deprecationLogger, AWSCredentialsProvider provider, String description) {
        try {
            AWSCredentials credentials = provider.getCredentials();
            if (credentials.getAWSAccessKeyId() != null && credentials.getAWSSecretKey() != null) {
                logger.debug("Using " + description + " credentials");
                deprecationLogger.deprecated("Supplying S3 credentials through " + description + " is deprecated. See the breaking changes lists in the documentation for details.", new Object[0]);
                return credentials;
            }
        }
        catch (Exception e) {
            logger.debug("Failed to get aws credentials from " + description, (Throwable)e);
        }
        return null;
    }

    static AWSCredentialsProvider buildCredentials(Logger logger, DeprecationLogger deprecationLogger, S3ClientSettings clientSettings, Settings repositorySettings) {
        BasicAWSCredentials credentials;
        block30: {
            credentials = clientSettings.credentials;
            if (S3Repository.Repository.KEY_SETTING.exists(repositorySettings)) {
                if (!S3Repository.Repository.SECRET_SETTING.exists(repositorySettings)) {
                    throw new IllegalArgumentException("Repository setting [" + S3Repository.Repository.KEY_SETTING + " must be accompanied by setting [" + S3Repository.Repository.SECRET_SETTING + "]");
                }
                deprecationLogger.deprecated("Using s3 access/secret key from repository settings. Instead store these in named clients and the elasticsearch keystore for secure settings.", new Object[0]);
                try (SecureString key = (SecureString)S3Repository.Repository.KEY_SETTING.get(repositorySettings);
                     SecureString secret = (SecureString)S3Repository.Repository.SECRET_SETTING.get(repositorySettings);){
                    credentials = new BasicAWSCredentials(key.toString(), secret.toString());
                    break block30;
                }
            }
            if (S3Repository.Repository.SECRET_SETTING.exists(repositorySettings)) {
                throw new IllegalArgumentException("Repository setting [" + S3Repository.Repository.SECRET_SETTING + " must be accompanied by setting [" + S3Repository.Repository.KEY_SETTING + "]");
            }
        }
        if (credentials == null) {
            AWSCredentials envCredentials = InternalAwsS3Service.getDeprecatedCredentials(logger, deprecationLogger, (AWSCredentialsProvider)new EnvironmentVariableCredentialsProvider(), "environment variables");
            if (envCredentials != null) {
                return new StaticCredentialsProvider(envCredentials);
            }
            AWSCredentials syspropCredentials = InternalAwsS3Service.getDeprecatedCredentials(logger, deprecationLogger, (AWSCredentialsProvider)new SystemPropertiesCredentialsProvider(), "system properties");
            if (syspropCredentials != null) {
                return new StaticCredentialsProvider(syspropCredentials);
            }
            logger.debug("Using instance profile credentials");
            return new InstanceProfileCredentialsProvider();
        }
        logger.debug("Using basic key/secret credentials");
        return new StaticCredentialsProvider((AWSCredentials)credentials);
    }

    static String findEndpoint(Logger logger, DeprecationLogger deprecationLogger, S3ClientSettings clientSettings, Settings repositorySettings) {
        String region = InternalAwsS3Service.getRepoValue(repositorySettings, S3Repository.Repository.REGION_SETTING, clientSettings.region);
        String endpoint = InternalAwsS3Service.getRepoValue(repositorySettings, S3Repository.Repository.ENDPOINT_SETTING, clientSettings.endpoint);
        if (Strings.isNullOrEmpty((String)endpoint)) {
            logger.debug("no repository level endpoint has been defined. Trying to guess from repository region [{}]", (Object)region);
            if (!region.isEmpty()) {
                deprecationLogger.deprecated("Specifying region for an s3 repository is deprecated. Use endpoint to specify the region endpoint if the default behavior is not sufficient.", new Object[0]);
                endpoint = InternalAwsS3Service.getEndpoint(region);
                logger.debug("using s3 region [{}], with endpoint [{}]", (Object)region, (Object)endpoint);
            }
        } else {
            logger.debug("using repository level endpoint [{}]", (Object)endpoint);
        }
        return endpoint;
    }

    public static String getRegion(Settings repositorySettings, Settings settings) {
        return S3Repository.getValue(repositorySettings, settings, S3Repository.Repository.REGION_SETTING, S3Repository.Repositories.REGION_SETTING);
    }

    private static String getEndpoint(String region) {
        String endpoint;
        switch (region) {
            case "us-east": 
            case "us-east-1": {
                endpoint = "s3.amazonaws.com";
                break;
            }
            case "us-east-2": {
                endpoint = "s3.us-east-2.amazonaws.com";
                break;
            }
            case "us-west": 
            case "us-west-1": {
                endpoint = "s3-us-west-1.amazonaws.com";
                break;
            }
            case "us-west-2": {
                endpoint = "s3-us-west-2.amazonaws.com";
                break;
            }
            case "ap-south": 
            case "ap-south-1": {
                endpoint = "s3-ap-south-1.amazonaws.com";
                break;
            }
            case "ap-southeast": 
            case "ap-southeast-1": {
                endpoint = "s3-ap-southeast-1.amazonaws.com";
                break;
            }
            case "ap-southeast-2": {
                endpoint = "s3-ap-southeast-2.amazonaws.com";
                break;
            }
            case "ap-northeast": 
            case "ap-northeast-1": {
                endpoint = "s3-ap-northeast-1.amazonaws.com";
                break;
            }
            case "ap-northeast-2": {
                endpoint = "s3-ap-northeast-2.amazonaws.com";
                break;
            }
            case "eu-west": 
            case "eu-west-1": {
                endpoint = "s3-eu-west-1.amazonaws.com";
                break;
            }
            case "eu-west-2": {
                endpoint = "s3-eu-west-2.amazonaws.com";
                break;
            }
            case "eu-central": 
            case "eu-central-1": {
                endpoint = "s3.eu-central-1.amazonaws.com";
                break;
            }
            case "sa-east": 
            case "sa-east-1": {
                endpoint = "s3-sa-east-1.amazonaws.com";
                break;
            }
            case "cn-north": 
            case "cn-north-1": {
                endpoint = "s3.cn-north-1.amazonaws.com.cn";
                break;
            }
            case "us-gov-west": 
            case "us-gov-west-1": {
                endpoint = "s3-us-gov-west-1.amazonaws.com";
                break;
            }
            case "ca-central": 
            case "ca-central-1": {
                endpoint = "s3.ca-central-1.amazonaws.com";
                break;
            }
            default: {
                throw new IllegalArgumentException("No automatic endpoint could be derived from region [" + region + "]");
            }
        }
        return endpoint;
    }

    private static <T> T getRepoValue(Settings repositorySettings, Setting<T> repositorySetting, T fallback) {
        if (repositorySetting.exists(repositorySettings)) {
            return (T)repositorySetting.get(repositorySettings);
        }
        return fallback;
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
        for (AmazonS3Client client : this.clientsCache.values()) {
            client.shutdown();
        }
        IdleConnectionReaper.shutdown();
    }
}

