/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cloud.aws.AwsS3Service;
import org.elasticsearch.cloud.aws.AwsSigner;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.repositories.s3.S3Repository;

public class InternalAwsS3Service
extends AbstractLifecycleComponent
implements AwsS3Service {
    static final Setting<String> CLIENT_NAME = new Setting("client", "default", Function.identity(), new Setting.Property[0]);
    private Map<Tuple<String, String>, AmazonS3Client> clients = new HashMap<Tuple<String, String>, AmazonS3Client>();

    public InternalAwsS3Service(Settings settings) {
        super(settings);
    }

    @Override
    public synchronized AmazonS3 client(Settings repositorySettings, Integer maxRetries, boolean useThrottleRetries, Boolean pathStyleAccess) {
        AWSCredentialsProvider credentials;
        String clientName = (String)CLIENT_NAME.get(repositorySettings);
        String foundEndpoint = InternalAwsS3Service.findEndpoint(this.logger, this.deprecationLogger, repositorySettings, this.settings, clientName);
        Tuple clientDescriptor = new Tuple((Object)foundEndpoint, (Object)(credentials = InternalAwsS3Service.buildCredentials(this.logger, this.deprecationLogger, this.settings, repositorySettings, clientName)).getCredentials().getAWSAccessKeyId());
        AmazonS3Client client = this.clients.get(clientDescriptor);
        if (client != null) {
            return client;
        }
        client = new AmazonS3Client(credentials, InternalAwsS3Service.buildConfiguration(this.logger, repositorySettings, this.settings, clientName, maxRetries, foundEndpoint, useThrottleRetries));
        if (pathStyleAccess != null) {
            client.setS3ClientOptions(new S3ClientOptions().withPathStyleAccess(pathStyleAccess.booleanValue()));
        }
        if (!foundEndpoint.isEmpty()) {
            client.setEndpoint(foundEndpoint);
        }
        this.clients.put((Tuple<String, String>)clientDescriptor, client);
        return client;
    }

    static ClientConfiguration buildConfiguration(Logger logger, Settings repositorySettings, Settings settings, String clientName, Integer maxRetries, String endpoint, boolean useThrottleRetries) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        Protocol protocol = InternalAwsS3Service.getConfigValue(repositorySettings, settings, clientName, S3Repository.PROTOCOL_SETTING, S3Repository.Repository.PROTOCOL_SETTING, S3Repository.Repositories.PROTOCOL_SETTING);
        clientConfiguration.setProtocol(protocol);
        String proxyHost = InternalAwsS3Service.getConfigValue(null, settings, clientName, S3Repository.PROXY_HOST_SETTING, null, AwsS3Service.CLOUD_S3.PROXY_HOST_SETTING);
        if (Strings.hasText((String)proxyHost)) {
            Integer proxyPort = InternalAwsS3Service.getConfigValue(null, settings, clientName, S3Repository.PROXY_PORT_SETTING, null, AwsS3Service.CLOUD_S3.PROXY_PORT_SETTING);
            try (SecureString proxyUsername = InternalAwsS3Service.getConfigValue(null, settings, clientName, S3Repository.PROXY_USERNAME_SETTING, null, AwsS3Service.CLOUD_S3.PROXY_USERNAME_SETTING);
                 SecureString proxyPassword = InternalAwsS3Service.getConfigValue(null, settings, clientName, S3Repository.PROXY_PASSWORD_SETTING, null, AwsS3Service.CLOUD_S3.PROXY_PASSWORD_SETTING);){
                clientConfiguration.withProxyHost(proxyHost).withProxyPort(proxyPort.intValue()).withProxyUsername(proxyUsername.toString()).withProxyPassword(proxyPassword.toString());
            }
        }
        if (maxRetries != null) {
            clientConfiguration.setMaxErrorRetry(maxRetries.intValue());
        }
        clientConfiguration.setUseThrottleRetries(useThrottleRetries);
        String awsSigner = (String)AwsS3Service.CLOUD_S3.SIGNER_SETTING.get(settings);
        if (Strings.hasText((String)awsSigner)) {
            logger.debug("using AWS API signer [{}]", (Object)awsSigner);
            AwsSigner.configureSigner(awsSigner, clientConfiguration, endpoint);
        }
        TimeValue readTimeout = InternalAwsS3Service.getConfigValue(null, settings, clientName, S3Repository.READ_TIMEOUT_SETTING, null, AwsS3Service.CLOUD_S3.READ_TIMEOUT);
        clientConfiguration.setSocketTimeout((int)readTimeout.millis());
        return clientConfiguration;
    }

    public static AWSCredentialsProvider buildCredentials(Logger logger, DeprecationLogger deprecationLogger, Settings settings, Settings repositorySettings, String clientName) {
        StaticCredentialsProvider credentials;
        try (SecureString key = InternalAwsS3Service.getConfigValue(repositorySettings, settings, clientName, S3Repository.ACCESS_KEY_SETTING, S3Repository.Repository.KEY_SETTING, S3Repository.Repositories.KEY_SETTING);
             SecureString secret = InternalAwsS3Service.getConfigValue(repositorySettings, settings, clientName, S3Repository.SECRET_KEY_SETTING, S3Repository.Repository.SECRET_SETTING, S3Repository.Repositories.SECRET_SETTING);){
            if (key.length() == 0 && secret.length() == 0) {
                AWSCredentials envCredentials = InternalAwsS3Service.getDeprecatedCredentials(logger, deprecationLogger, (AWSCredentialsProvider)new EnvironmentVariableCredentialsProvider(), "environment variables");
                if (envCredentials != null) {
                    credentials = new StaticCredentialsProvider(envCredentials);
                } else {
                    AWSCredentials syspropCredentials = InternalAwsS3Service.getDeprecatedCredentials(logger, deprecationLogger, (AWSCredentialsProvider)new SystemPropertiesCredentialsProvider(), "system properties");
                    if (syspropCredentials != null) {
                        credentials = new StaticCredentialsProvider(syspropCredentials);
                    } else {
                        logger.debug("Using instance profile credentials");
                        credentials = new InstanceProfileCredentialsProvider();
                    }
                }
            } else {
                logger.debug("Using basic key/secret credentials");
                credentials = new StaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(key.toString(), secret.toString()));
            }
        }
        return credentials;
    }

    private static AWSCredentials getDeprecatedCredentials(Logger logger, DeprecationLogger deprecationLogger, AWSCredentialsProvider provider, String description) {
        try {
            AWSCredentials credentials = provider.getCredentials();
            if (credentials.getAWSAccessKeyId() != null && credentials.getAWSSecretKey() != null) {
                logger.debug("Using " + description + " credentials");
                deprecationLogger.deprecated("Supplying S3 credentials through " + description + " is deprecated. See the breaking changes lists in the documentation for details.", new Object[0]);
                return credentials;
            }
        }
        catch (Exception e) {
            logger.debug("Failed to get aws credentials from " + description, (Throwable)e);
        }
        return null;
    }

    static String findEndpoint(Logger logger, DeprecationLogger deprecationLogger, Settings repositorySettings, Settings settings, String clientName) {
        String region = InternalAwsS3Service.getRegion(repositorySettings, settings);
        String endpoint = InternalAwsS3Service.getConfigValue(repositorySettings, settings, clientName, S3Repository.ENDPOINT_SETTING, S3Repository.Repository.ENDPOINT_SETTING, S3Repository.Repositories.ENDPOINT_SETTING);
        if (Strings.isNullOrEmpty((String)endpoint)) {
            logger.debug("no repository level endpoint has been defined. Trying to guess from repository region [{}]", (Object)region);
            if (!region.isEmpty()) {
                deprecationLogger.deprecated("Specifying region for an s3 repository is deprecated. Use endpoint to specify the region endpoint if the default behavior is not sufficient.", new Object[0]);
                endpoint = InternalAwsS3Service.getEndpoint(region);
                logger.debug("using s3 region [{}], with endpoint [{}]", (Object)region, (Object)endpoint);
            } else if (AwsS3Service.CLOUD_S3.ENDPOINT_SETTING.exists(settings)) {
                endpoint = (String)AwsS3Service.CLOUD_S3.ENDPOINT_SETTING.get(settings);
                logger.debug("using explicit s3 endpoint [{}]", (Object)endpoint);
            } else if (REGION_SETTING.exists(settings) || AwsS3Service.CLOUD_S3.REGION_SETTING.exists(settings)) {
                region = (String)AwsS3Service.CLOUD_S3.REGION_SETTING.get(settings);
                endpoint = InternalAwsS3Service.getEndpoint(region);
                logger.debug("using s3 region [{}], with endpoint [{}]", (Object)region, (Object)endpoint);
            }
        } else {
            logger.debug("using repository level endpoint [{}]", (Object)endpoint);
        }
        return endpoint;
    }

    public static String getRegion(Settings repositorySettings, Settings settings) {
        return S3Repository.getValue(repositorySettings, settings, S3Repository.Repository.REGION_SETTING, S3Repository.Repositories.REGION_SETTING);
    }

    private static String getEndpoint(String region) {
        String endpoint;
        switch (region) {
            case "us-east": 
            case "us-east-1": {
                endpoint = "s3.amazonaws.com";
                break;
            }
            case "us-east-2": {
                endpoint = "s3.us-east-2.amazonaws.com";
                break;
            }
            case "us-west": 
            case "us-west-1": {
                endpoint = "s3-us-west-1.amazonaws.com";
                break;
            }
            case "us-west-2": {
                endpoint = "s3-us-west-2.amazonaws.com";
                break;
            }
            case "ap-south": 
            case "ap-south-1": {
                endpoint = "s3-ap-south-1.amazonaws.com";
                break;
            }
            case "ap-southeast": 
            case "ap-southeast-1": {
                endpoint = "s3-ap-southeast-1.amazonaws.com";
                break;
            }
            case "ap-southeast-2": {
                endpoint = "s3-ap-southeast-2.amazonaws.com";
                break;
            }
            case "ap-northeast": 
            case "ap-northeast-1": {
                endpoint = "s3-ap-northeast-1.amazonaws.com";
                break;
            }
            case "ap-northeast-2": {
                endpoint = "s3-ap-northeast-2.amazonaws.com";
                break;
            }
            case "eu-west": 
            case "eu-west-1": {
                endpoint = "s3-eu-west-1.amazonaws.com";
                break;
            }
            case "eu-west-2": {
                endpoint = "s3-eu-west-2.amazonaws.com";
                break;
            }
            case "eu-central": 
            case "eu-central-1": {
                endpoint = "s3.eu-central-1.amazonaws.com";
                break;
            }
            case "sa-east": 
            case "sa-east-1": {
                endpoint = "s3-sa-east-1.amazonaws.com";
                break;
            }
            case "cn-north": 
            case "cn-north-1": {
                endpoint = "s3.cn-north-1.amazonaws.com.cn";
                break;
            }
            case "us-gov-west": 
            case "us-gov-west-1": {
                endpoint = "s3-us-gov-west-1.amazonaws.com";
                break;
            }
            case "ca-central": 
            case "ca-central-1": {
                endpoint = "s3.ca-central-1.amazonaws.com";
                break;
            }
            default: {
                throw new IllegalArgumentException("No automatic endpoint could be derived from region [" + region + "]");
            }
        }
        return endpoint;
    }

    private static <T> T getConfigValue(Settings repositorySettings, Settings globalSettings, String clientName, Setting.AffixSetting<T> configSetting, Setting<T> repositorySetting, Setting<T> globalSetting) {
        Setting concreteSetting = configSetting.getConcreteSettingForNamespace(clientName);
        if (concreteSetting.exists(globalSettings)) {
            return (T)concreteSetting.get(globalSettings);
        }
        if (repositorySetting == null) {
            return (T)globalSetting.get(globalSettings);
        }
        return S3Repository.getValue(repositorySettings, globalSettings, repositorySetting, globalSetting);
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
        for (AmazonS3Client client : this.clients.values()) {
            client.shutdown();
        }
        IdleConnectionReaper.shutdown();
    }
}

