/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.SignerFactory;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;

public class AwsSigner {
    private static final Logger logger = Loggers.getLogger(AwsSigner.class);

    private AwsSigner() {
    }

    protected static void validateSignerType(String signer, String endpoint) {
        if (signer == null) {
            throw new IllegalArgumentException("[null] signer set");
        }
        switch (signer) {
            case "S3SignerType": {
                if (!endpoint.equals("s3.cn-north-1.amazonaws.com.cn") && !endpoint.equals("s3.eu-central-1.amazonaws.com")) break;
                throw new IllegalArgumentException("[S3SignerType] may not be supported in aws Beijing and Frankfurt region");
            }
            case "AWSS3V4SignerType": {
                break;
            }
            default: {
                try {
                    SignerFactory.getSignerByTypeAndService((String)signer, null);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("[" + signer + "] may not be supported");
                }
            }
        }
    }

    public static void configureSigner(String signer, ClientConfiguration configuration, String endpoint) {
        try {
            AwsSigner.validateSignerType(signer, endpoint);
        }
        catch (IllegalArgumentException e) {
            logger.warn("{}", (Object)e.getMessage());
        }
        configuration.setSignerOverride(signer);
    }
}

