/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.Protocol;
import java.io.IOException;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.cloud.aws.AwsS3Service;
import org.elasticsearch.cloud.aws.blobstore.S3BlobStore;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;

public class S3Repository
extends BlobStoreRepository {
    public static final String TYPE = "s3";
    private final S3BlobStore blobStore;
    private final BlobPath basePath;
    private ByteSizeValue chunkSize;
    private boolean compress;

    public S3Repository(RepositoryMetaData metadata, Settings settings, NamedXContentRegistry namedXContentRegistry, AwsS3Service s3Service) throws IOException {
        super(metadata, settings, namedXContentRegistry);
        String bucket = S3Repository.getValue(metadata.settings(), settings, Repository.BUCKET_SETTING, Repositories.BUCKET_SETTING);
        if (bucket == null) {
            throw new RepositoryException(metadata.name(), "No bucket defined for s3 gateway");
        }
        String endpoint = S3Repository.getValue(metadata.settings(), settings, Repository.ENDPOINT_SETTING, Repositories.ENDPOINT_SETTING);
        Protocol protocol = S3Repository.getValue(metadata.settings(), settings, Repository.PROTOCOL_SETTING, Repositories.PROTOCOL_SETTING);
        String region = S3Repository.getValue(metadata.settings(), settings, Repository.REGION_SETTING, Repositories.REGION_SETTING);
        boolean serverSideEncryption = S3Repository.getValue(metadata.settings(), settings, Repository.SERVER_SIDE_ENCRYPTION_SETTING, Repositories.SERVER_SIDE_ENCRYPTION_SETTING);
        ByteSizeValue bufferSize = S3Repository.getValue(metadata.settings(), settings, Repository.BUFFER_SIZE_SETTING, Repositories.BUFFER_SIZE_SETTING);
        Integer maxRetries = S3Repository.getValue(metadata.settings(), settings, Repository.MAX_RETRIES_SETTING, Repositories.MAX_RETRIES_SETTING);
        boolean useThrottleRetries = S3Repository.getValue(metadata.settings(), settings, Repository.USE_THROTTLE_RETRIES_SETTING, Repositories.USE_THROTTLE_RETRIES_SETTING);
        this.chunkSize = S3Repository.getValue(metadata.settings(), settings, Repository.CHUNK_SIZE_SETTING, Repositories.CHUNK_SIZE_SETTING);
        this.compress = S3Repository.getValue(metadata.settings(), settings, Repository.COMPRESS_SETTING, Repositories.COMPRESS_SETTING);
        if (this.chunkSize.getBytes() < bufferSize.getBytes()) {
            throw new RepositoryException(metadata.name(), Repository.CHUNK_SIZE_SETTING.getKey() + " (" + this.chunkSize + ") can't be lower than " + Repository.BUFFER_SIZE_SETTING.getKey() + " (" + bufferSize + ").");
        }
        String storageClass = S3Repository.getValue(metadata.settings(), settings, Repository.STORAGE_CLASS_SETTING, Repositories.STORAGE_CLASS_SETTING);
        String cannedACL = S3Repository.getValue(metadata.settings(), settings, Repository.CANNED_ACL_SETTING, Repositories.CANNED_ACL_SETTING);
        Boolean pathStyleAccess = null;
        if (Repository.PATH_STYLE_ACCESS_SETTING.exists(metadata.settings()) || Repositories.PATH_STYLE_ACCESS_SETTING.exists(settings)) {
            pathStyleAccess = S3Repository.getValue(metadata.settings(), settings, Repository.PATH_STYLE_ACCESS_SETTING, Repositories.PATH_STYLE_ACCESS_SETTING);
        }
        this.logger.debug("using bucket [{}], region [{}], endpoint [{}], protocol [{}], chunk_size [{}], server_side_encryption [{}], buffer_size [{}], max_retries [{}], use_throttle_retries [{}], cannedACL [{}], storageClass [{}], path_style_access [{}]", new Object[]{bucket, region, endpoint, protocol, this.chunkSize, serverSideEncryption, bufferSize, maxRetries, useThrottleRetries, cannedACL, storageClass, pathStyleAccess});
        this.blobStore = new S3BlobStore(settings, s3Service.client(metadata.settings(), endpoint, protocol, region, maxRetries, useThrottleRetries, pathStyleAccess), bucket, region, serverSideEncryption, bufferSize, maxRetries, cannedACL, storageClass);
        String basePath = S3Repository.getValue(metadata.settings(), settings, Repository.BASE_PATH_SETTING, Repositories.BASE_PATH_SETTING);
        if (Strings.hasLength((String)basePath)) {
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
                this.deprecationLogger.deprecated("S3 repository base_path trimming the leading `/`, and leading `/` will not be supported for the S3 repository in future releases", new Object[0]);
            }
            this.basePath = new BlobPath().add(basePath);
        } else {
            this.basePath = BlobPath.cleanPath();
        }
    }

    protected BlobStore blobStore() {
        return this.blobStore;
    }

    protected BlobPath basePath() {
        return this.basePath;
    }

    protected boolean isCompress() {
        return this.compress;
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    public static <T> T getValue(Settings repositorySettings, Settings globalSettings, Setting<T> repositorySetting, Setting<T> repositoriesSetting) {
        if (repositorySetting.exists(repositorySettings)) {
            return (T)repositorySetting.get(repositorySettings);
        }
        return (T)repositoriesSetting.get(globalSettings);
    }

    public static interface Repository {
        public static final Setting<String> KEY_SETTING = Setting.simpleString((String)"access_key", (Setting.Property[])new Setting.Property[0]);
        public static final Setting<String> SECRET_SETTING = Setting.simpleString((String)"secret_key", (Setting.Property[])new Setting.Property[0]);
        public static final Setting<String> BUCKET_SETTING = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[0]);
        public static final Setting<String> ENDPOINT_SETTING = Setting.simpleString((String)"endpoint", (Setting.Property[])new Setting.Property[0]);
        public static final Setting<Protocol> PROTOCOL_SETTING = new Setting("protocol", "https", s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), new Setting.Property[0]);
        public static final Setting<String> REGION_SETTING = new Setting("region", "", s -> s.toLowerCase(Locale.ROOT), new Setting.Property[0]);
        public static final Setting<Boolean> SERVER_SIDE_ENCRYPTION_SETTING = Setting.boolSetting((String)"server_side_encryption", (boolean)false, (Setting.Property[])new Setting.Property[0]);
        public static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting((String)"buffer_size", (ByteSizeValue)Repositories.DEFAULT_BUFFER_SIZE, (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.TB), (Setting.Property[])new Setting.Property[0]);
        public static final Setting<Integer> MAX_RETRIES_SETTING = Setting.intSetting((String)"max_retries", (int)3, (Setting.Property[])new Setting.Property[0]);
        public static final Setting<Boolean> USE_THROTTLE_RETRIES_SETTING = Setting.boolSetting((String)"use_throttle_retries", (boolean)false, (Setting.Property[])new Setting.Property[0]);
        public static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.GB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.TB), (Setting.Property[])new Setting.Property[0]);
        public static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting((String)"compress", (boolean)false, (Setting.Property[])new Setting.Property[0]);
        public static final Setting<String> STORAGE_CLASS_SETTING = Setting.simpleString((String)"storage_class", (Setting.Property[])new Setting.Property[0]);
        public static final Setting<String> CANNED_ACL_SETTING = Setting.simpleString((String)"canned_acl", (Setting.Property[])new Setting.Property[0]);
        public static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[0]);
        public static final Setting<Boolean> PATH_STYLE_ACCESS_SETTING = Setting.boolSetting((String)"path_style_access", (boolean)false, (Setting.Property[])new Setting.Property[0]);
    }

    public static interface Repositories {
        public static final Setting<String> KEY_SETTING = new Setting("repositories.s3.access_key", AwsS3Service.CLOUD_S3.KEY_SETTING, Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        public static final Setting<String> SECRET_SETTING = new Setting("repositories.s3.secret_key", AwsS3Service.CLOUD_S3.SECRET_SETTING, Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        public static final Setting<String> REGION_SETTING = new Setting("repositories.s3.region", AwsS3Service.CLOUD_S3.REGION_SETTING, s -> s.toLowerCase(Locale.ROOT), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> ENDPOINT_SETTING = new Setting("repositories.s3.endpoint", AwsS3Service.CLOUD_S3.ENDPOINT_SETTING, s -> s.toLowerCase(Locale.ROOT), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Protocol> PROTOCOL_SETTING = new Setting("repositories.s3.protocol", AwsS3Service.CLOUD_S3.PROTOCOL_SETTING, s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> BUCKET_SETTING = Setting.simpleString((String)"repositories.s3.bucket", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Boolean> SERVER_SIDE_ENCRYPTION_SETTING = Setting.boolSetting((String)"repositories.s3.server_side_encryption", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final ByteSizeValue DEFAULT_BUFFER_SIZE = new ByteSizeValue(Math.max(ByteSizeUnit.MB.toBytes(5L), Math.min(ByteSizeUnit.MB.toBytes(100L), JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 20L)), ByteSizeUnit.BYTES);
        public static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting((String)"repositories.s3.buffer_size", (ByteSizeValue)DEFAULT_BUFFER_SIZE, (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.TB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Integer> MAX_RETRIES_SETTING = Setting.intSetting((String)"repositories.s3.max_retries", (int)3, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Boolean> USE_THROTTLE_RETRIES_SETTING = Setting.boolSetting((String)"repositories.s3.use_throttle_retries", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"repositories.s3.chunk_size", (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.GB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.TB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting((String)"repositories.s3.compress", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> STORAGE_CLASS_SETTING = Setting.simpleString((String)"repositories.s3.storage_class", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> CANNED_ACL_SETTING = Setting.simpleString((String)"repositories.s3.canned_acl", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"repositories.s3.base_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Boolean> PATH_STYLE_ACCESS_SETTING = Setting.boolSetting((String)"repositories.s3.path_style_access", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    }
}

