/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cloud.aws.AwsS3Service;
import org.elasticsearch.cloud.aws.AwsSigner;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.repositories.s3.S3Repository;

public class InternalAwsS3Service
extends AbstractLifecycleComponent
implements AwsS3Service {
    private Map<Tuple<String, String>, AmazonS3Client> clients = new HashMap<Tuple<String, String>, AmazonS3Client>();

    public InternalAwsS3Service(Settings settings) {
        super(settings);
    }

    @Override
    public synchronized AmazonS3 client(Settings repositorySettings, String endpoint, Protocol protocol, String region, Integer maxRetries, boolean useThrottleRetries, Boolean pathStyleAccess) {
        AWSCredentialsProvider credentials;
        String foundEndpoint = InternalAwsS3Service.findEndpoint(this.logger, this.settings, endpoint, region);
        Tuple clientDescriptor = new Tuple((Object)foundEndpoint, (Object)(credentials = InternalAwsS3Service.buildCredentials(this.logger, this.settings, repositorySettings)).getCredentials().getAWSAccessKeyId());
        AmazonS3Client client = this.clients.get(clientDescriptor);
        if (client != null) {
            return client;
        }
        client = new AmazonS3Client(credentials, InternalAwsS3Service.buildConfiguration(this.logger, this.settings, protocol, maxRetries, foundEndpoint, useThrottleRetries));
        if (pathStyleAccess != null) {
            client.setS3ClientOptions(new S3ClientOptions().withPathStyleAccess(pathStyleAccess.booleanValue()));
        }
        if (!foundEndpoint.isEmpty()) {
            client.setEndpoint(foundEndpoint);
        }
        this.clients.put((Tuple<String, String>)clientDescriptor, client);
        return client;
    }

    public static ClientConfiguration buildConfiguration(Logger logger, Settings settings, Protocol protocol, Integer maxRetries, String endpoint, boolean useThrottleRetries) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol(protocol);
        String proxyHost = (String)AwsS3Service.CLOUD_S3.PROXY_HOST_SETTING.get(settings);
        if (Strings.hasText((String)proxyHost)) {
            Integer proxyPort = (Integer)AwsS3Service.CLOUD_S3.PROXY_PORT_SETTING.get(settings);
            String proxyUsername = (String)AwsS3Service.CLOUD_S3.PROXY_USERNAME_SETTING.get(settings);
            String proxyPassword = (String)AwsS3Service.CLOUD_S3.PROXY_PASSWORD_SETTING.get(settings);
            clientConfiguration.withProxyHost(proxyHost).withProxyPort(proxyPort.intValue()).withProxyUsername(proxyUsername).withProxyPassword(proxyPassword);
        }
        if (maxRetries != null) {
            clientConfiguration.setMaxErrorRetry(maxRetries.intValue());
        }
        clientConfiguration.setUseThrottleRetries(useThrottleRetries);
        String awsSigner = (String)AwsS3Service.CLOUD_S3.SIGNER_SETTING.get(settings);
        if (Strings.hasText((String)awsSigner)) {
            logger.debug("using AWS API signer [{}]", (Object)awsSigner);
            AwsSigner.configureSigner(awsSigner, clientConfiguration, endpoint);
        }
        clientConfiguration.setSocketTimeout((int)((TimeValue)AwsS3Service.CLOUD_S3.READ_TIMEOUT.get(settings)).millis());
        return clientConfiguration;
    }

    public static AWSCredentialsProvider buildCredentials(Logger logger, Settings settings, Settings repositorySettings) {
        DefaultAWSCredentialsProviderChain credentials;
        String key = S3Repository.getValue(repositorySettings, settings, S3Repository.Repository.KEY_SETTING, S3Repository.Repositories.KEY_SETTING);
        String secret = S3Repository.getValue(repositorySettings, settings, S3Repository.Repository.SECRET_SETTING, S3Repository.Repositories.SECRET_SETTING);
        if (key.isEmpty() && secret.isEmpty()) {
            logger.debug("Using either environment variables, system properties or instance profile credentials");
            credentials = new DefaultAWSCredentialsProviderChain();
        } else {
            logger.debug("Using basic key/secret credentials");
            credentials = new StaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(key, secret));
        }
        return credentials;
    }

    protected static String findEndpoint(Logger logger, Settings settings, String endpoint, String region) {
        if (Strings.isNullOrEmpty((String)endpoint)) {
            logger.debug("no repository level endpoint has been defined. Trying to guess from repository region [{}]", (Object)region);
            if (!region.isEmpty()) {
                endpoint = InternalAwsS3Service.getEndpoint(region);
                logger.debug("using s3 region [{}], with endpoint [{}]", (Object)region, (Object)endpoint);
            } else if (AwsS3Service.CLOUD_S3.ENDPOINT_SETTING.exists(settings)) {
                endpoint = (String)AwsS3Service.CLOUD_S3.ENDPOINT_SETTING.get(settings);
                logger.debug("using explicit s3 endpoint [{}]", (Object)endpoint);
            } else if (REGION_SETTING.exists(settings) || AwsS3Service.CLOUD_S3.REGION_SETTING.exists(settings)) {
                region = (String)AwsS3Service.CLOUD_S3.REGION_SETTING.get(settings);
                endpoint = InternalAwsS3Service.getEndpoint(region);
                logger.debug("using s3 region [{}], with endpoint [{}]", (Object)region, (Object)endpoint);
            }
        } else {
            logger.debug("using repository level endpoint [{}]", (Object)endpoint);
        }
        return endpoint;
    }

    private static String getEndpoint(String region) {
        String endpoint;
        switch (region) {
            case "us-east": 
            case "us-east-1": {
                endpoint = "s3.amazonaws.com";
                break;
            }
            case "us-east-2": {
                endpoint = "s3.us-east-2.amazonaws.com";
                break;
            }
            case "us-west": 
            case "us-west-1": {
                endpoint = "s3-us-west-1.amazonaws.com";
                break;
            }
            case "us-west-2": {
                endpoint = "s3-us-west-2.amazonaws.com";
                break;
            }
            case "ap-south": 
            case "ap-south-1": {
                endpoint = "s3-ap-south-1.amazonaws.com";
                break;
            }
            case "ap-southeast": 
            case "ap-southeast-1": {
                endpoint = "s3-ap-southeast-1.amazonaws.com";
                break;
            }
            case "ap-southeast-2": {
                endpoint = "s3-ap-southeast-2.amazonaws.com";
                break;
            }
            case "ap-northeast": 
            case "ap-northeast-1": {
                endpoint = "s3-ap-northeast-1.amazonaws.com";
                break;
            }
            case "ap-northeast-2": {
                endpoint = "s3-ap-northeast-2.amazonaws.com";
                break;
            }
            case "eu-west": 
            case "eu-west-1": {
                endpoint = "s3-eu-west-1.amazonaws.com";
                break;
            }
            case "eu-west-2": {
                endpoint = "s3-eu-west-2.amazonaws.com";
                break;
            }
            case "eu-central": 
            case "eu-central-1": {
                endpoint = "s3.eu-central-1.amazonaws.com";
                break;
            }
            case "sa-east": 
            case "sa-east-1": {
                endpoint = "s3-sa-east-1.amazonaws.com";
                break;
            }
            case "cn-north": 
            case "cn-north-1": {
                endpoint = "s3.cn-north-1.amazonaws.com.cn";
                break;
            }
            case "us-gov-west": 
            case "us-gov-west-1": {
                endpoint = "s3-us-gov-west-1.amazonaws.com";
                break;
            }
            case "ca-central": 
            case "ca-central-1": {
                endpoint = "s3.ca-central-1.amazonaws.com";
                break;
            }
            default: {
                throw new IllegalArgumentException("No automatic endpoint could be derived from region [" + region + "]");
            }
        }
        return endpoint;
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
        for (AmazonS3Client client : this.clients.values()) {
            client.shutdown();
        }
        IdleConnectionReaper.shutdown();
    }
}

