/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cloud.aws.AwsS3Service;
import org.elasticsearch.cloud.aws.AwsSigner;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.s3.S3Repository;

public class InternalAwsS3Service
extends AbstractLifecycleComponent
implements AwsS3Service {
    private Map<Tuple<String, String>, AmazonS3Client> clients = new HashMap<Tuple<String, String>, AmazonS3Client>();

    public InternalAwsS3Service(Settings settings) {
        super(settings);
    }

    @Override
    public synchronized AmazonS3 client(Settings repositorySettings, String endpoint, Protocol protocol, String region, Integer maxRetries, boolean useThrottleRetries, Boolean pathStyleAccess) {
        AWSCredentialsProvider credentials;
        String foundEndpoint = InternalAwsS3Service.findEndpoint(this.logger, this.settings, endpoint, region);
        Tuple clientDescriptor = new Tuple((Object)foundEndpoint, (Object)(credentials = InternalAwsS3Service.buildCredentials(this.logger, this.settings, repositorySettings)).getCredentials().getAWSAccessKeyId());
        AmazonS3Client client = this.clients.get(clientDescriptor);
        if (client != null) {
            return client;
        }
        client = new AmazonS3Client(credentials, InternalAwsS3Service.buildConfiguration(this.logger, this.settings, protocol, maxRetries, foundEndpoint, useThrottleRetries));
        if (pathStyleAccess != null) {
            client.setS3ClientOptions(new S3ClientOptions().withPathStyleAccess(pathStyleAccess.booleanValue()));
        }
        if (!foundEndpoint.isEmpty()) {
            client.setEndpoint(foundEndpoint);
        }
        this.clients.put((Tuple<String, String>)clientDescriptor, client);
        return client;
    }

    public static ClientConfiguration buildConfiguration(Logger logger, Settings settings, Protocol protocol, Integer maxRetries, String endpoint, boolean useThrottleRetries) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol(protocol);
        String proxyHost = (String)AwsS3Service.CLOUD_S3.PROXY_HOST_SETTING.get(settings);
        if (Strings.hasText((String)proxyHost)) {
            Integer proxyPort = (Integer)AwsS3Service.CLOUD_S3.PROXY_PORT_SETTING.get(settings);
            String proxyUsername = (String)AwsS3Service.CLOUD_S3.PROXY_USERNAME_SETTING.get(settings);
            String proxyPassword = (String)AwsS3Service.CLOUD_S3.PROXY_PASSWORD_SETTING.get(settings);
            clientConfiguration.withProxyHost(proxyHost).withProxyPort(proxyPort.intValue()).withProxyUsername(proxyUsername).withProxyPassword(proxyPassword);
        }
        if (maxRetries != null) {
            clientConfiguration.setMaxErrorRetry(maxRetries.intValue());
        }
        clientConfiguration.setUseThrottleRetries(useThrottleRetries);
        String awsSigner = (String)AwsS3Service.CLOUD_S3.SIGNER_SETTING.get(settings);
        if (Strings.hasText((String)awsSigner)) {
            logger.debug("using AWS API signer [{}]", (Object)awsSigner);
            AwsSigner.configureSigner(awsSigner, clientConfiguration, endpoint);
        }
        return clientConfiguration;
    }

    public static AWSCredentialsProvider buildCredentials(Logger logger, Settings settings, Settings repositorySettings) {
        DefaultAWSCredentialsProviderChain credentials;
        String key = S3Repository.getValue(repositorySettings, settings, S3Repository.Repository.KEY_SETTING, S3Repository.Repositories.KEY_SETTING);
        String secret = S3Repository.getValue(repositorySettings, settings, S3Repository.Repository.SECRET_SETTING, S3Repository.Repositories.SECRET_SETTING);
        if (key.isEmpty() && secret.isEmpty()) {
            logger.debug("Using either environment variables, system properties or instance profile credentials");
            credentials = new DefaultAWSCredentialsProviderChain();
        } else {
            logger.debug("Using basic key/secret credentials");
            credentials = new StaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(key, secret));
        }
        return credentials;
    }

    protected static String findEndpoint(Logger logger, Settings settings, String endpoint, String region) {
        if (Strings.isNullOrEmpty((String)endpoint)) {
            logger.debug("no repository level endpoint has been defined. Trying to guess from repository region [{}]", (Object)region);
            if (!region.isEmpty()) {
                endpoint = InternalAwsS3Service.getEndpoint(region);
                logger.debug("using s3 region [{}], with endpoint [{}]", (Object)region, (Object)endpoint);
            } else if (AwsS3Service.CLOUD_S3.ENDPOINT_SETTING.exists(settings)) {
                endpoint = (String)AwsS3Service.CLOUD_S3.ENDPOINT_SETTING.get(settings);
                logger.debug("using explicit s3 endpoint [{}]", (Object)endpoint);
            } else if (REGION_SETTING.exists(settings) || AwsS3Service.CLOUD_S3.REGION_SETTING.exists(settings)) {
                region = (String)AwsS3Service.CLOUD_S3.REGION_SETTING.get(settings);
                endpoint = InternalAwsS3Service.getEndpoint(region);
                logger.debug("using s3 region [{}], with endpoint [{}]", (Object)region, (Object)endpoint);
            }
        } else {
            logger.debug("using repository level endpoint [{}]", (Object)endpoint);
        }
        return endpoint;
    }

    private static String getEndpoint(String region) {
        if ("us-east".equals(region) || "us-east-1".equals(region)) {
            return "s3.amazonaws.com";
        }
        if ("us-west".equals(region) || "us-west-1".equals(region)) {
            return "s3-us-west-1.amazonaws.com";
        }
        if ("us-west-2".equals(region)) {
            return "s3-us-west-2.amazonaws.com";
        }
        if (region.equals("ap-south-1")) {
            return "s3-ap-south-1.amazonaws.com";
        }
        if ("ap-southeast".equals(region) || "ap-southeast-1".equals(region)) {
            return "s3-ap-southeast-1.amazonaws.com";
        }
        if ("ap-southeast-2".equals(region)) {
            return "s3-ap-southeast-2.amazonaws.com";
        }
        if ("ap-northeast".equals(region) || "ap-northeast-1".equals(region)) {
            return "s3-ap-northeast-1.amazonaws.com";
        }
        if ("ap-northeast-2".equals(region)) {
            return "s3-ap-northeast-2.amazonaws.com";
        }
        if ("eu-west".equals(region) || "eu-west-1".equals(region)) {
            return "s3-eu-west-1.amazonaws.com";
        }
        if ("eu-central".equals(region) || "eu-central-1".equals(region)) {
            return "s3.eu-central-1.amazonaws.com";
        }
        if ("sa-east".equals(region) || "sa-east-1".equals(region)) {
            return "s3-sa-east-1.amazonaws.com";
        }
        if ("cn-north".equals(region) || "cn-north-1".equals(region)) {
            return "s3.cn-north-1.amazonaws.com.cn";
        }
        if ("us-gov-west".equals(region) || "us-gov-west-1".equals(region)) {
            return "s3-us-gov-west-1.amazonaws.com";
        }
        throw new IllegalArgumentException("No automatic endpoint could be derived from region [" + region + "]");
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
        for (AmazonS3Client client : this.clients.values()) {
            client.shutdown();
        }
        IdleConnectionReaper.shutdown();
    }
}

