/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.top.window;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.top.window.RollingWindow;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RollingWindowManager {
    public static final Logger LOG = LoggerFactory.getLogger(RollingWindowManager.class);
    private final int windowLenMs;
    private final int bucketsPerWindow;
    private final int topUsersCnt;
    public ConcurrentHashMap<String, RollingWindowMap> metricMap = new ConcurrentHashMap();

    public RollingWindowManager(Configuration conf, int reportingPeriodMs) {
        this.windowLenMs = reportingPeriodMs;
        this.bucketsPerWindow = conf.getInt("dfs.namenode.top.window.num.buckets", 10);
        Preconditions.checkArgument((this.bucketsPerWindow > 0 ? 1 : 0) != 0, (Object)"a window should have at least one bucket");
        Preconditions.checkArgument((this.bucketsPerWindow <= this.windowLenMs ? 1 : 0) != 0, (Object)"the minimum size of a bucket is 1 ms");
        Preconditions.checkArgument((this.windowLenMs % this.bucketsPerWindow == 0 ? 1 : 0) != 0, (Object)"window size must be a multiplication of number of buckets");
        this.topUsersCnt = conf.getInt("dfs.namenode.top.num.users", 10);
        Preconditions.checkArgument((this.topUsersCnt > 0 ? 1 : 0) != 0, (Object)"the number of requested top users must be at least 1");
    }

    public void recordMetric(long time, String command, String user, long delta) {
        RollingWindow window = this.getRollingWindow(command, user);
        window.incAt(time, delta);
    }

    public TopWindow snapshot(long time) {
        TopWindow window = new TopWindow(this.windowLenMs);
        Set metricNames = this.metricMap.keySet();
        LOG.debug("iterating in reported metrics, size={} values={}", (Object)metricNames.size(), (Object)metricNames);
        UserCounts totalCounts = new UserCounts(this.metricMap.size());
        for (Map.Entry<String, RollingWindowMap> entry : this.metricMap.entrySet()) {
            RollingWindowMap rollingWindows;
            String metricName = entry.getKey();
            UserCounts topN = this.getTopUsersForMetric(time, metricName, rollingWindows = entry.getValue());
            if (topN.isEmpty()) continue;
            window.addOp(new Op(metricName, topN, this.topUsersCnt));
            totalCounts.addAll(topN);
        }
        HashSet<User> topUsers = new HashSet<User>();
        for (Op op : window.getOps()) {
            topUsers.addAll(op.getTopUsers());
        }
        totalCounts.retainAll(topUsers);
        window.addOp(new Op("*", totalCounts, Integer.MAX_VALUE));
        return window;
    }

    private UserCounts getTopUsersForMetric(long time, String metricName, RollingWindowMap rollingWindows) {
        UserCounts topN = new UserCounts(this.topUsersCnt);
        Iterator iterator = rollingWindows.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String userName = (String)entry.getKey();
            RollingWindow aWindow = (RollingWindow)entry.getValue();
            long windowSum = aWindow.getSum(time);
            if (windowSum == 0L) {
                LOG.debug("gc window of metric: {} userName: {}", (Object)metricName, (Object)userName);
                iterator.remove();
                continue;
            }
            LOG.debug("offer window of metric: {} userName: {} sum: {}", new Object[]{metricName, userName, windowSum});
            topN.add(new User(userName, windowSum));
        }
        LOG.debug("topN users size for command {} is: {}", (Object)metricName, (Object)topN.size());
        return topN;
    }

    private RollingWindow getRollingWindow(String metric, String user) {
        RollingWindow window;
        RollingWindowMap prevRwMap;
        RollingWindowMap rwMap = this.metricMap.get(metric);
        if (rwMap == null && (prevRwMap = this.metricMap.putIfAbsent(metric, rwMap = new RollingWindowMap())) != null) {
            rwMap = prevRwMap;
        }
        if ((window = (RollingWindow)rwMap.get(user)) != null) {
            return window;
        }
        window = new RollingWindow(this.windowLenMs, this.bucketsPerWindow);
        RollingWindow prevWindow = rwMap.putIfAbsent(user, window);
        if (prevWindow != null) {
            window = prevWindow;
        }
        return window;
    }

    private static class UserCounts
    extends ArrayList<User> {
        private long total = 0L;

        UserCounts(int capacity) {
            super(capacity);
        }

        @Override
        public boolean add(User user) {
            long count = user.getCount();
            int i = this.indexOf(user);
            if (i == -1) {
                super.add(new User(user.getUser(), count));
            } else {
                ((User)this.get(i)).add(count);
            }
            this.total += count;
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends User> users) {
            users.forEach((? super T user) -> this.add((User)user));
            return true;
        }

        public long getTotal() {
            return this.total;
        }
    }

    public static class User
    implements Comparable<User> {
        private final String user;
        private long count;

        public User(String user, long count) {
            this.user = user;
            this.count = count;
        }

        public String getUser() {
            return this.user;
        }

        public long getCount() {
            return this.count;
        }

        public void add(long delta) {
            this.count += delta;
        }

        @Override
        public int compareTo(User other) {
            return Long.signum(this.count - other.count);
        }

        public boolean equals(Object o) {
            return o instanceof User && this.user.equals(((User)o).user);
        }

        public int hashCode() {
            return this.user.hashCode();
        }
    }

    public static class Op
    implements Comparable<Op> {
        private final String opType;
        private final List<User> users;
        private final long totalCount;
        private final int limit;

        public Op(String opType, UserCounts users, int limit) {
            this.opType = opType;
            this.users = new ArrayList<User>(users);
            this.users.sort(Collections.reverseOrder());
            this.totalCount = users.getTotal();
            this.limit = limit;
        }

        public String getOpType() {
            return this.opType;
        }

        public List<User> getAllUsers() {
            return this.users;
        }

        public List<User> getTopUsers() {
            return this.users.size() > this.limit ? this.users.subList(0, this.limit) : this.users;
        }

        public long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public int compareTo(Op other) {
            return Long.signum(this.totalCount - other.totalCount);
        }

        public boolean equals(Object o) {
            return o instanceof Op && this.totalCount == ((Op)o).totalCount;
        }

        public int hashCode() {
            return this.opType.hashCode();
        }
    }

    public static class TopWindow {
        private final int windowMillis;
        private final List<Op> top;

        public TopWindow(int windowMillis) {
            this.windowMillis = windowMillis;
            this.top = new LinkedList<Op>();
        }

        public void addOp(Op op) {
            if (op.getOpType().equals("*")) {
                this.top.add(0, op);
            } else {
                this.top.add(op);
            }
        }

        public int getWindowLenMs() {
            return this.windowMillis;
        }

        public List<Op> getOps() {
            return this.top;
        }
    }

    private static class RollingWindowMap
    extends ConcurrentHashMap<String, RollingWindow> {
        private static final long serialVersionUID = -6785807073237052051L;

        private RollingWindowMap() {
        }
    }
}

