/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.hdfs;

import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesMetrics;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.hdfs.HdfsRepository;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public final class HdfsPlugin
extends Plugin
implements RepositoryPlugin {
    private static Void eagerInitSecurityUtil() {
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HdfsRepository.class.getClassLoader());
            KerberosInfo info = SecurityUtil.getKerberosInfo(ClientNamenodeProtocolPB.class, null);
            if (info == null) {
                throw new RuntimeException("Could not initialize SecurityUtil: Unable to find services for [org.apache.hadoop.security.SecurityInfo]");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        return null;
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, RepositoriesMetrics repositoriesMetrics) {
        return Collections.singletonMap("hdfs", metadata -> new HdfsRepository(metadata, env, namedXContentRegistry, clusterService, bigArrays, recoverySettings));
    }

    static {
        HdfsPlugin.eagerInitSecurityUtil();
    }
}

