/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.hdfs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.elasticsearch.env.Environment;

class HdfsSecurityContext {
    private final UserGroupInformation ugi;

    static Path locateKeytabFile(Environment environment) {
        Path keytabPath = environment.configDir().resolve("repository-hdfs").resolve("krb5.keytab");
        try {
            if (!Files.exists(keytabPath, new LinkOption[0])) {
                throw new RuntimeException("Could not locate keytab at [" + keytabPath + "].");
            }
        }
        catch (SecurityException se) {
            throw new RuntimeException("Could not locate keytab at [" + keytabPath + "]", se);
        }
        return keytabPath;
    }

    HdfsSecurityContext(UserGroupInformation ugi) {
        this.ugi = ugi;
    }

    void ensureLogin() {
        if (this.ugi.isFromKeytab()) {
            try {
                this.ugi.checkTGTAndReloginFromKeytab();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("Could not re-authenticate", ioe);
            }
        }
    }
}

