/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.hdfs;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.repositories.hdfs.HdfsBlobStore;
import org.elasticsearch.repositories.hdfs.HdfsSecurityContext;

final class HdfsBlobContainer
extends AbstractBlobContainer {
    private final HdfsBlobStore store;
    private final HdfsSecurityContext securityContext;
    private final Path path;
    private final int bufferSize;
    private final Short replicationFactor;
    private final Options.CreateOpts[] createOpts;
    private static final DeleteResult DELETE_RESULT = new DeleteResult(1L, 0L);

    HdfsBlobContainer(BlobPath blobPath, HdfsBlobStore store, Path path, int bufferSize, HdfsSecurityContext hdfsSecurityContext, Short replicationFactor) {
        super(blobPath);
        Options.CreateOpts[] createOptsArray;
        this.store = store;
        this.securityContext = hdfsSecurityContext;
        this.path = path;
        this.bufferSize = bufferSize;
        this.replicationFactor = replicationFactor;
        if (replicationFactor == null) {
            createOptsArray = new Options.CreateOpts[]{};
        } else {
            Options.CreateOpts[] createOptsArray2 = new Options.CreateOpts[1];
            createOptsArray = createOptsArray2;
            createOptsArray2[0] = Options.CreateOpts.repFac((short)replicationFactor);
        }
        this.createOpts = createOptsArray;
    }

    public boolean blobExists(OperationPurpose purpose, String blobName) throws IOException {
        return this.store.execute(fileContext -> fileContext.util().exists(new Path(this.path, blobName)));
    }

    public DeleteResult delete(OperationPurpose purpose) throws IOException {
        this.store.execute(fileContext -> fileContext.delete(this.path, true));
        return DELETE_RESULT;
    }

    public void deleteBlobsIgnoringIfNotExists(OperationPurpose purpose, Iterator<String> blobNames) throws IOException {
        IOException ioe = null;
        while (blobNames.hasNext()) {
            String blobName = blobNames.next();
            try {
                this.store.execute(fileContext -> fileContext.delete(new Path(this.path, blobName), true));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                if (ioe == null) {
                    ioe = e;
                    continue;
                }
                ioe.addSuppressed(e);
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public InputStream readBlob(OperationPurpose purpose, String blobName) throws IOException {
        try {
            return this.store.execute(fileContext -> new HDFSPrivilegedInputSteam((InputStream)fileContext.open(new Path(this.path, blobName), this.bufferSize), this.securityContext));
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException("[" + blobName + "] blob not found");
        }
    }

    public InputStream readBlob(OperationPurpose purpose, String blobName, long position, long length) throws IOException {
        try {
            return this.store.execute(fileContext -> {
                FSDataInputStream fsInput = fileContext.open(new Path(this.path, blobName), this.bufferSize);
                fsInput.seek(position);
                return Streams.limitStream((InputStream)new HDFSPrivilegedInputSteam((InputStream)fsInput, this.securityContext), (long)length);
            });
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException("[" + blobName + "] blob not found");
        }
    }

    public void writeBlob(OperationPurpose purpose, String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        Path blob = new Path(this.path, blobName);
        EnumSet<CreateFlag> flags = failIfAlreadyExists ? EnumSet.of(CreateFlag.CREATE, CreateFlag.SYNC_BLOCK) : EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE, CreateFlag.SYNC_BLOCK);
        this.store.execute(fileContext -> {
            try {
                this.writeToPath(inputStream, blobSize, fileContext, blob, flags);
            }
            catch (FileAlreadyExistsException faee) {
                throw new java.nio.file.FileAlreadyExistsException(blob.toString(), null, faee.getMessage());
            }
            return null;
        });
    }

    public void writeBlob(OperationPurpose purpose, String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        Path blob = new Path(this.path, blobName);
        EnumSet<CreateFlag> flags = failIfAlreadyExists ? EnumSet.of(CreateFlag.CREATE, CreateFlag.SYNC_BLOCK) : EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE, CreateFlag.SYNC_BLOCK);
        this.store.execute(fileContext -> {
            try {
                this.writeToPath(bytes, blob, fileContext, flags);
            }
            catch (FileAlreadyExistsException faee) {
                throw new java.nio.file.FileAlreadyExistsException(blob.toString(), null, faee.getMessage());
            }
            return null;
        });
    }

    public void writeMetadataBlob(OperationPurpose purpose, String blobName, boolean failIfAlreadyExists, boolean atomic, CheckedConsumer<OutputStream, IOException> writer) throws IOException {
        Path blob = new Path(this.path, blobName);
        if (atomic) {
            Path tempBlobPath = new Path(this.path, FsBlobContainer.tempBlobName((String)blobName));
            this.store.execute(fileContext -> {
                try {
                    try (FSDataOutputStream stream = fileContext.create(tempBlobPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.SYNC_BLOCK), this.createOpts);){
                        writer.accept((Object)stream);
                    }
                    fileContext.rename(tempBlobPath, blob, new Options.Rename[]{failIfAlreadyExists ? Options.Rename.NONE : Options.Rename.OVERWRITE});
                }
                catch (FileAlreadyExistsException faee) {
                    throw new java.nio.file.FileAlreadyExistsException(blob.toString(), null, faee.getMessage());
                }
                return null;
            });
        } else {
            EnumSet<CreateFlag> flags = failIfAlreadyExists ? EnumSet.of(CreateFlag.CREATE, CreateFlag.SYNC_BLOCK) : EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE, CreateFlag.SYNC_BLOCK);
            this.store.execute(fileContext -> {
                try (FSDataOutputStream stream = fileContext.create(blob, flags, this.createOpts);){
                    writer.accept((Object)stream);
                }
                catch (FileAlreadyExistsException faee) {
                    throw new java.nio.file.FileAlreadyExistsException(blob.toString(), null, faee.getMessage());
                }
                return null;
            });
        }
    }

    public void writeBlobAtomic(OperationPurpose purpose, String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        String tempBlob = FsBlobContainer.tempBlobName((String)blobName);
        Path tempBlobPath = new Path(this.path, tempBlob);
        Path blob = new Path(this.path, blobName);
        this.store.execute(fileContext -> {
            this.writeToPath(bytes, tempBlobPath, fileContext, EnumSet.of(CreateFlag.CREATE, CreateFlag.SYNC_BLOCK));
            try {
                fileContext.rename(tempBlobPath, blob, new Options.Rename[]{failIfAlreadyExists ? Options.Rename.NONE : Options.Rename.OVERWRITE});
            }
            catch (FileAlreadyExistsException faee) {
                throw new java.nio.file.FileAlreadyExistsException(blob.toString(), null, faee.getMessage());
            }
            return null;
        });
    }

    private void writeToPath(BytesReference bytes, Path blobPath, FileContext fileContext, EnumSet<CreateFlag> createFlags) throws IOException {
        try (FSDataOutputStream stream = fileContext.create(blobPath, createFlags, this.createOpts);){
            bytes.writeTo((OutputStream)stream);
        }
    }

    private void writeToPath(InputStream inputStream, long blobSize, FileContext fileContext, Path blobPath, EnumSet<CreateFlag> createFlags) throws IOException {
        byte[] buffer = new byte[blobSize < (long)this.bufferSize ? Math.toIntExact(blobSize) : this.bufferSize];
        Options.CreateOpts[] createOptsWithBufferSize = HdfsBlobContainer.addOptionToArray(this.createOpts, (Options.CreateOpts)Options.CreateOpts.bufferSize((int)buffer.length));
        try (FSDataOutputStream stream = fileContext.create(blobPath, createFlags, createOptsWithBufferSize);){
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                stream.write(buffer, 0, bytesRead);
            }
        }
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(OperationPurpose purpose, @Nullable String prefix) throws IOException {
        FileStatus[] files;
        try {
            files = this.store.execute(fileContext -> fileContext.util().listStatus(this.path, eachPath -> prefix == null || eachPath.getName().startsWith(prefix)));
        }
        catch (FileNotFoundException e) {
            files = new FileStatus[]{};
        }
        LinkedHashMap<String, BlobMetadata> map = new LinkedHashMap<String, BlobMetadata>();
        for (FileStatus file : files) {
            if (!file.isFile()) continue;
            map.put(file.getPath().getName(), new BlobMetadata(file.getPath().getName(), file.getLen()));
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<String, BlobMetadata> listBlobs(OperationPurpose purpose) throws IOException {
        return this.listBlobsByPrefix(purpose, null);
    }

    public Map<String, BlobContainer> children(OperationPurpose purpose) throws IOException {
        FileStatus[] files = this.store.execute(fileContext -> fileContext.util().listStatus(this.path));
        LinkedHashMap<String, HdfsBlobContainer> map = new LinkedHashMap<String, HdfsBlobContainer>();
        for (FileStatus file : files) {
            if (!file.isDirectory()) continue;
            String name = file.getPath().getName();
            map.put(name, new HdfsBlobContainer(this.path().add(name), this.store, new Path(this.path, name), this.bufferSize, this.securityContext, this.replicationFactor));
        }
        return Collections.unmodifiableMap(map);
    }

    public void compareAndExchangeRegister(OperationPurpose purpose, String key, BytesReference expected, BytesReference updated, ActionListener<OptionalBytesReference> listener) {
        listener.onFailure((Exception)new UnsupportedOperationException("HDFS repositories do not support this operation"));
    }

    private static Options.CreateOpts[] addOptionToArray(Options.CreateOpts[] opts, Options.CreateOpts opt) {
        if (opts == null) {
            return new Options.CreateOpts[]{opt};
        }
        Options.CreateOpts[] newOpts = new Options.CreateOpts[opts.length + 1];
        System.arraycopy(opts, 0, newOpts, 0, opts.length);
        newOpts[opts.length] = opt;
        return newOpts;
    }

    private static class HDFSPrivilegedInputSteam
    extends FilterInputStream {
        private final HdfsSecurityContext securityContext;

        HDFSPrivilegedInputSteam(InputStream in, HdfsSecurityContext hdfsSecurityContext) {
            super(in);
            this.securityContext = hdfsSecurityContext;
        }

        @Override
        public int read() throws IOException {
            return this.securityContext.doPrivilegedOrThrow(this.in::read);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.securityContext.doPrivilegedOrThrow(() -> this.in.read(b));
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.securityContext.doPrivilegedOrThrow(() -> this.in.read(b, off, len));
        }

        @Override
        public long skip(long n) throws IOException {
            return this.securityContext.doPrivilegedOrThrow(() -> this.in.skip(n));
        }

        @Override
        public int available() throws IOException {
            return this.securityContext.doPrivilegedOrThrow(() -> this.in.available());
        }

        @Override
        public synchronized void reset() throws IOException {
            this.securityContext.doPrivilegedOrThrow(() -> {
                this.in.reset();
                return null;
            });
        }
    }
}

