/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Time;

class FSDirMkdirOp {
    FSDirMkdirOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus mkdirs(FSNamesystem fsn, String src, PermissionStatus permissions, boolean createParent) throws IOException {
        FSDirectory fsd = fsn.getFSDirectory();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.mkdirs: " + src);
        }
        FSPermissionChecker pc = fsd.getPermissionChecker();
        fsd.writeLock();
        try {
            INodesInPath iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.CREATE);
            INode lastINode = iip.getLastINode();
            if (lastINode != null && lastINode.isFile()) {
                throw new FileAlreadyExistsException("Path is not a directory: " + src);
            }
            if (lastINode == null) {
                if (fsd.isPermissionEnabled()) {
                    fsd.checkAncestorAccess(pc, iip, FsAction.WRITE);
                }
                if (!createParent) {
                    fsd.verifyParentDir(iip);
                }
                fsn.checkFsObjectLimit();
                INodesInPath existing = FSDirMkdirOp.createParentDirectories(fsd, iip, permissions, false);
                if (existing != null) {
                    existing = FSDirMkdirOp.createSingleDirectory(fsd, existing, iip.getLastLocalName(), permissions);
                }
                if (existing == null) {
                    throw new IOException("Failed to create directory: " + src);
                }
                iip = existing;
            }
            HdfsFileStatus hdfsFileStatus = fsd.getAuditFileInfo(iip);
            return hdfsFileStatus;
        }
        finally {
            fsd.writeUnlock();
        }
    }

    static INodesInPath createAncestorDirectories(FSDirectory fsd, INodesInPath iip, PermissionStatus permission) throws IOException {
        return FSDirMkdirOp.createParentDirectories(fsd, iip, permission, true);
    }

    private static INodesInPath createParentDirectories(FSDirectory fsd, INodesInPath iip, PermissionStatus perm, boolean inheritPerms) throws IOException {
        assert (fsd.hasWriteLock());
        INodesInPath existing = iip.getExistingINodes();
        int missing = iip.length() - existing.length();
        if (missing == 0) {
            existing = iip.getParentINodesInPath();
        } else if (missing > 1) {
            PermissionStatus basePerm = inheritPerms ? existing.getLastINode().getPermissionStatus() : perm;
            perm = FSDirMkdirOp.addImplicitUwx(basePerm, perm);
            int last = iip.length() - 2;
            for (int i = existing.length(); existing != null && i <= last; ++i) {
                byte[] component = iip.getPathComponent(i);
                existing = FSDirMkdirOp.createSingleDirectory(fsd, existing, component, perm);
            }
        }
        return existing;
    }

    static void mkdirForEditLog(FSDirectory fsd, long inodeId, String src, PermissionStatus permissions, List<AclEntry> aclEntries, long timestamp) throws QuotaExceededException, UnresolvedLinkException, AclException, FileAlreadyExistsException, ParentNotDirectoryException, AccessControlException {
        assert (fsd.hasWriteLock());
        INodesInPath iip = fsd.getINodesInPath(src, FSDirectory.DirOp.WRITE_LINK);
        byte[] localName = iip.getLastLocalName();
        INodesInPath existing = iip.getParentINodesInPath();
        Preconditions.checkState((existing.getLastINode() != null ? 1 : 0) != 0);
        FSDirMkdirOp.unprotectedMkdir(fsd, inodeId, existing, localName, permissions, aclEntries, timestamp);
    }

    private static INodesInPath createSingleDirectory(FSDirectory fsd, INodesInPath existing, byte[] localName, PermissionStatus perm) throws IOException {
        assert (fsd.hasWriteLock());
        existing = FSDirMkdirOp.unprotectedMkdir(fsd, fsd.allocateNewInodeId(), existing, localName, perm, null, Time.now());
        if (existing == null) {
            return null;
        }
        INode newNode = existing.getLastINode();
        NameNode.getNameNodeMetrics().incrFilesCreated();
        String cur = existing.getPath();
        fsd.getEditLog().logMkDir(cur, newNode);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("mkdirs: created directory " + cur);
        }
        return existing;
    }

    private static PermissionStatus addImplicitUwx(PermissionStatus parentPerm, PermissionStatus perm) {
        FsPermission p = parentPerm.getPermission();
        FsPermission ancestorPerm = new FsPermission(p.getUserAction().or(FsAction.WRITE_EXECUTE), p.getGroupAction(), p.getOtherAction());
        return new PermissionStatus(perm.getUserName(), perm.getGroupName(), ancestorPerm);
    }

    private static INodesInPath unprotectedMkdir(FSDirectory fsd, long inodeId, INodesInPath parent, byte[] name, PermissionStatus permission, List<AclEntry> aclEntries, long timestamp) throws QuotaExceededException, AclException, FileAlreadyExistsException {
        assert (fsd.hasWriteLock());
        assert (parent.getLastINode() != null);
        if (!parent.getLastINode().isDirectory()) {
            throw new FileAlreadyExistsException("Parent path is not a directory: " + parent.getPath() + " " + DFSUtil.bytes2String(name));
        }
        INodeDirectory dir = new INodeDirectory(inodeId, name, permission, timestamp);
        INodesInPath iip = fsd.addLastINode(parent, dir, true);
        if (iip != null && aclEntries != null) {
            AclStorage.updateINodeAcl(dir, aclEntries, 0x7FFFFFFE);
        }
        return iip;
    }
}

