/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.hdfs;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.PlainBlobMetaData;
import org.elasticsearch.repositories.hdfs.HdfsBlobStore;
import org.elasticsearch.repositories.hdfs.HdfsSecurityContext;

final class HdfsBlobContainer
extends AbstractBlobContainer {
    private final HdfsBlobStore store;
    private final HdfsSecurityContext securityContext;
    private final Path path;
    private final int bufferSize;
    private static final DeleteResult DELETE_RESULT = new DeleteResult(1L, 0L);

    HdfsBlobContainer(BlobPath blobPath, HdfsBlobStore store, Path path, int bufferSize, HdfsSecurityContext hdfsSecurityContext) {
        super(blobPath);
        this.store = store;
        this.securityContext = hdfsSecurityContext;
        this.path = path;
        this.bufferSize = bufferSize;
    }

    public void deleteBlob(String blobName) throws IOException {
        try {
            if (!this.store.execute(fileContext -> fileContext.delete(new Path(this.path, blobName), true)).booleanValue()) {
                throw new NoSuchFileException("Blob [" + blobName + "] does not exist");
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException("[" + blobName + "] blob not found");
        }
    }

    public DeleteResult delete() throws IOException {
        this.store.execute(fileContext -> fileContext.delete(this.path, true));
        return DELETE_RESULT;
    }

    public InputStream readBlob(String blobName) throws IOException {
        try {
            return this.store.execute(fileContext -> new HDFSPrivilegedInputSteam((InputStream)fileContext.open(new Path(this.path, blobName), this.bufferSize), this.securityContext));
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException("[" + blobName + "] blob not found");
        }
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.store.execute(fileContext -> {
            Path blob = new Path(this.path, blobName);
            EnumSet<CreateFlag> flags = failIfAlreadyExists ? EnumSet.of(CreateFlag.CREATE, CreateFlag.SYNC_BLOCK) : EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE, CreateFlag.SYNC_BLOCK);
            try (FSDataOutputStream stream = fileContext.create(blob, flags, new Options.CreateOpts[]{Options.CreateOpts.bufferSize((int)this.bufferSize)});){
                int bytesRead;
                byte[] buffer = new byte[this.bufferSize];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    stream.write(buffer, 0, bytesRead);
                }
            }
            catch (FileAlreadyExistsException faee) {
                throw new java.nio.file.FileAlreadyExistsException(blob.toString(), null, faee.getMessage());
            }
            return null;
        });
    }

    public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        String tempBlob = FsBlobContainer.tempBlobName((String)blobName);
        this.store.execute(fileContext -> {
            Path tempBlobPath = new Path(this.path, tempBlob);
            try (FSDataOutputStream stream = fileContext.create(tempBlobPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.SYNC_BLOCK), new Options.CreateOpts[]{Options.CreateOpts.bufferSize((int)this.bufferSize)});){
                int bytesRead;
                byte[] buffer = new byte[this.bufferSize];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    stream.write(buffer, 0, bytesRead);
                }
            }
            Path blob = new Path(this.path, blobName);
            try {
                fileContext.rename(tempBlobPath, blob, new Options.Rename[]{failIfAlreadyExists ? Options.Rename.NONE : Options.Rename.OVERWRITE});
            }
            catch (FileAlreadyExistsException faee) {
                throw new java.nio.file.FileAlreadyExistsException(blob.toString(), null, faee.getMessage());
            }
            return null;
        });
    }

    public Map<String, BlobMetaData> listBlobsByPrefix(@Nullable String prefix) throws IOException {
        FileStatus[] files = this.store.execute(fileContext -> fileContext.util().listStatus(this.path, path -> prefix == null || path.getName().startsWith(prefix)));
        LinkedHashMap<String, PlainBlobMetaData> map = new LinkedHashMap<String, PlainBlobMetaData>();
        for (FileStatus file : files) {
            if (!file.isFile()) continue;
            map.put(file.getPath().getName(), new PlainBlobMetaData(file.getPath().getName(), file.getLen()));
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<String, BlobMetaData> listBlobs() throws IOException {
        return this.listBlobsByPrefix(null);
    }

    public Map<String, BlobContainer> children() throws IOException {
        FileStatus[] files = this.store.execute(fileContext -> fileContext.util().listStatus(this.path));
        LinkedHashMap<String, HdfsBlobContainer> map = new LinkedHashMap<String, HdfsBlobContainer>();
        for (FileStatus file : files) {
            if (!file.isDirectory()) continue;
            String name = file.getPath().getName();
            map.put(name, new HdfsBlobContainer(this.path().add(name), this.store, new Path(this.path, name), this.bufferSize, this.securityContext));
        }
        return Collections.unmodifiableMap(map);
    }

    private static class HDFSPrivilegedInputSteam
    extends FilterInputStream {
        private final HdfsSecurityContext securityContext;

        HDFSPrivilegedInputSteam(InputStream in, HdfsSecurityContext hdfsSecurityContext) {
            super(in);
            this.securityContext = hdfsSecurityContext;
        }

        @Override
        public int read() throws IOException {
            return this.securityContext.doPrivilegedOrThrow(this.in::read);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.securityContext.doPrivilegedOrThrow(() -> this.in.read(b));
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.securityContext.doPrivilegedOrThrow(() -> this.in.read(b, off, len));
        }

        @Override
        public long skip(long n) throws IOException {
            return this.securityContext.doPrivilegedOrThrow(() -> this.in.skip(n));
        }

        @Override
        public int available() throws IOException {
            return this.securityContext.doPrivilegedOrThrow(() -> this.in.available());
        }

        @Override
        public synchronized void reset() throws IOException {
            this.securityContext.doPrivilegedOrThrow(() -> {
                this.in.reset();
                return null;
            });
        }
    }
}

