/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class FilterFs
extends AbstractFileSystem {
    private final AbstractFileSystem myFs;

    protected AbstractFileSystem getMyFs() {
        return this.myFs;
    }

    protected FilterFs(AbstractFileSystem fs) throws URISyntaxException {
        super(fs.getUri(), fs.getUri().getScheme(), fs.getUri().getAuthority() != null, fs.getUriDefaultPort());
        this.myFs = fs;
    }

    @Override
    public FileSystem.Statistics getStatistics() {
        return this.myFs.getStatistics();
    }

    @Override
    public Path makeQualified(Path path) {
        return this.myFs.makeQualified(path);
    }

    @Override
    public Path getInitialWorkingDirectory() {
        return this.myFs.getInitialWorkingDirectory();
    }

    @Override
    public Path getHomeDirectory() {
        return this.myFs.getHomeDirectory();
    }

    @Override
    public FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws IOException, UnresolvedLinkException {
        this.checkPath(f);
        return this.myFs.createInternal(f, flag, absolutePermission, bufferSize, replication, blockSize, progress, checksumOpt, createParent);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException, UnresolvedLinkException {
        this.checkPath(f);
        return this.myFs.delete(f, recursive);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws IOException, UnresolvedLinkException {
        this.checkPath(f);
        return this.myFs.getFileBlockLocations(f, start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException, UnresolvedLinkException {
        this.checkPath(f);
        return this.myFs.getFileChecksum(f);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException, UnresolvedLinkException {
        this.checkPath(f);
        return this.myFs.getFileStatus(f);
    }

    @Override
    public void access(Path path, FsAction mode) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.checkPath(path);
        this.myFs.access(path, mode);
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws IOException, UnresolvedLinkException {
        this.checkPath(f);
        return this.myFs.getFileLinkStatus(f);
    }

    @Override
    public FsStatus getFsStatus(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.myFs.getFsStatus(f);
    }

    @Override
    public FsStatus getFsStatus() throws IOException {
        return this.myFs.getFsStatus();
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.myFs.getServerDefaults();
    }

    @Override
    public Path resolvePath(Path p) throws FileNotFoundException, UnresolvedLinkException, AccessControlException, IOException {
        return this.myFs.resolvePath(p);
    }

    @Override
    public int getUriDefaultPort() {
        return this.myFs.getUriDefaultPort();
    }

    @Override
    public URI getUri() {
        return this.myFs.getUri();
    }

    @Override
    public void checkPath(Path path) {
        this.myFs.checkPath(path);
    }

    @Override
    public String getUriPath(Path p) {
        return this.myFs.getUriPath(p);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException, UnresolvedLinkException {
        this.checkPath(f);
        return this.myFs.listStatus(f);
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.checkPath(f);
        return this.myFs.listLocatedStatus(f);
    }

    @Override
    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        return this.myFs.listCorruptFileBlocks(path);
    }

    @Override
    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws IOException, UnresolvedLinkException {
        this.checkPath(dir);
        this.myFs.mkdir(dir, permission, createParent);
    }

    @Override
    public FSDataInputStream open(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.checkPath(f);
        return this.myFs.open(f);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException, UnresolvedLinkException {
        this.checkPath(f);
        return this.myFs.open(f, bufferSize);
    }

    @Override
    public boolean truncate(Path f, long newLength) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.checkPath(f);
        return this.myFs.truncate(f, newLength);
    }

    @Override
    public void renameInternal(Path src, Path dst) throws IOException, UnresolvedLinkException {
        this.checkPath(src);
        this.checkPath(dst);
        this.myFs.rename(src, dst, Options.Rename.NONE);
    }

    @Override
    public void renameInternal(Path src, Path dst, boolean overwrite) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnresolvedLinkException, IOException {
        this.myFs.renameInternal(src, dst, overwrite);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws IOException, UnresolvedLinkException {
        this.checkPath(f);
        this.myFs.setOwner(f, username, groupname);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws IOException, UnresolvedLinkException {
        this.checkPath(f);
        this.myFs.setPermission(f, permission);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws IOException, UnresolvedLinkException {
        this.checkPath(f);
        return this.myFs.setReplication(f, replication);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws IOException, UnresolvedLinkException {
        this.checkPath(f);
        this.myFs.setTimes(f, mtime, atime);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) throws IOException, UnresolvedLinkException {
        this.myFs.setVerifyChecksum(verifyChecksum);
    }

    @Override
    public boolean supportsSymlinks() {
        return this.myFs.supportsSymlinks();
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws IOException, UnresolvedLinkException {
        this.myFs.createSymlink(target, link, createParent);
    }

    @Override
    public Path getLinkTarget(Path f) throws IOException {
        return this.myFs.getLinkTarget(f);
    }

    @Override
    public String getCanonicalServiceName() {
        return this.myFs.getCanonicalServiceName();
    }

    @Override
    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        return this.myFs.getDelegationTokens(renewer);
    }

    @Override
    public boolean isValidName(String src) {
        return this.myFs.isValidName(src);
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.myFs.modifyAclEntries(path, aclSpec);
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.myFs.removeAclEntries(path, aclSpec);
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        this.myFs.removeDefaultAcl(path);
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        this.myFs.removeAcl(path);
    }

    @Override
    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        this.myFs.setAcl(path, aclSpec);
    }

    @Override
    public AclStatus getAclStatus(Path path) throws IOException {
        return this.myFs.getAclStatus(path);
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value) throws IOException {
        this.myFs.setXAttr(path, name, value);
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.myFs.setXAttr(path, name, value, flag);
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        return this.myFs.getXAttr(path, name);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        return this.myFs.getXAttrs(path);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        return this.myFs.getXAttrs(path, names);
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        return this.myFs.listXAttrs(path);
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        this.myFs.removeXAttr(path, name);
    }

    @Override
    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        return this.myFs.createSnapshot(path, snapshotName);
    }

    @Override
    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.myFs.renameSnapshot(path, snapshotOldName, snapshotNewName);
    }

    @Override
    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        this.myFs.deleteSnapshot(path, snapshotName);
    }

    @Override
    public void setStoragePolicy(Path path, String policyName) throws IOException {
        this.myFs.setStoragePolicy(path, policyName);
    }

    @Override
    public void unsetStoragePolicy(Path src) throws IOException {
        this.myFs.unsetStoragePolicy(src);
    }

    @Override
    public BlockStoragePolicySpi getStoragePolicy(Path src) throws IOException {
        return this.myFs.getStoragePolicy(src);
    }

    @Override
    public Collection<? extends BlockStoragePolicySpi> getAllStoragePolicies() throws IOException {
        return this.myFs.getAllStoragePolicies();
    }
}

