/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.internal;

import javax.annotation.Nullable;

public final class Utils {
    private Utils() {
    }

    public static void checkArgument(boolean isValid, String message) {
        if (!isValid) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkState(boolean isValid, String message) {
        if (!isValid) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkIndex(int index, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative size: " + size);
        }
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("Index out of bounds: size=" + size + ", index=" + index);
        }
    }

    public static <T> T checkNotNull(T arg, String message) {
        if (arg == null) {
            throw new NullPointerException(message);
        }
        return arg;
    }

    public static boolean equalsObjects(@Nullable Object x, @Nullable Object y) {
        return x == null ? y == null : x.equals(y);
    }
}

