/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.repositories.gcs.SocketAccess;

public class GoogleCloudStorageClientSettings {
    private static final String PREFIX = "gcs.client.";
    static final Setting.AffixSetting<InputStream> CREDENTIALS_FILE_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"credentials_file", key -> SecureSetting.secureFile((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> ENDPOINT_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"endpoint", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> PROJECT_ID_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"project_id", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<URI> TOKEN_URI_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"token_uri", key -> new Setting(key, "", URI::create, new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<TimeValue> CONNECT_TIMEOUT_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"connect_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.ZERO, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<TimeValue> READ_TIMEOUT_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.ZERO, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> APPLICATION_NAME_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"application_name", key -> new Setting(key, "repository-gcs", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private final ServiceAccountCredentials credential;
    private final String endpoint;
    private final String projectId;
    private final TimeValue connectTimeout;
    private final TimeValue readTimeout;
    private final String applicationName;
    private final URI tokenUri;

    GoogleCloudStorageClientSettings(ServiceAccountCredentials credential, String endpoint, String projectId, TimeValue connectTimeout, TimeValue readTimeout, String applicationName, URI tokenUri) {
        this.credential = credential;
        this.endpoint = endpoint;
        this.projectId = projectId;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.applicationName = applicationName;
        this.tokenUri = tokenUri;
    }

    public ServiceAccountCredentials getCredential() {
        return this.credential;
    }

    public String getHost() {
        return this.endpoint;
    }

    public String getProjectId() {
        return Strings.hasLength((String)this.projectId) ? this.projectId : (this.credential != null ? this.credential.getProjectId() : null);
    }

    public TimeValue getConnectTimeout() {
        return this.connectTimeout;
    }

    public TimeValue getReadTimeout() {
        return this.readTimeout;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public URI getTokenUri() {
        return this.tokenUri;
    }

    public static Map<String, GoogleCloudStorageClientSettings> load(Settings settings) {
        HashMap<String, GoogleCloudStorageClientSettings> clients = new HashMap<String, GoogleCloudStorageClientSettings>();
        for (String clientName : settings.getGroups(PREFIX).keySet()) {
            clients.put(clientName, GoogleCloudStorageClientSettings.getClientSettings(settings, clientName));
        }
        if (!clients.containsKey("default")) {
            clients.put("default", GoogleCloudStorageClientSettings.getClientSettings(settings, "default"));
        }
        return Collections.unmodifiableMap(clients);
    }

    static GoogleCloudStorageClientSettings getClientSettings(Settings settings, String clientName) {
        return new GoogleCloudStorageClientSettings(GoogleCloudStorageClientSettings.loadCredential(settings, clientName), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, ENDPOINT_SETTING), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, PROJECT_ID_SETTING), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, CONNECT_TIMEOUT_SETTING), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, READ_TIMEOUT_SETTING), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, APPLICATION_NAME_SETTING), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, TOKEN_URI_SETTING));
    }

    static ServiceAccountCredentials loadCredential(Settings settings, String clientName) {
        ServiceAccountCredentials serviceAccountCredentials;
        block9: {
            Setting credentialsFileSetting = CREDENTIALS_FILE_SETTING.getConcreteSettingForNamespace(clientName);
            if (!credentialsFileSetting.exists(settings)) {
                return null;
            }
            InputStream credStream = (InputStream)credentialsFileSetting.get(settings);
            try {
                Set<String> scopes = Collections.singleton("https://www.googleapis.com/auth/devstorage.full_control");
                serviceAccountCredentials = SocketAccess.doPrivilegedIOException(() -> {
                    ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)credStream);
                    if (credentials.createScopedRequired()) {
                        return (ServiceAccountCredentials)credentials.createScoped(scopes);
                    }
                    return credentials;
                });
                if (credStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (credStream != null) {
                        try {
                            credStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("failed to load GCS client credentials from [" + credentialsFileSetting.getKey() + "]", e);
                }
            }
            credStream.close();
        }
        return serviceAccountCredentials;
    }

    private static <T> T getConfigValue(Settings settings, String clientName, Setting.AffixSetting<T> clientSetting) {
        Setting concreteSetting = clientSetting.getConcreteSettingForNamespace(clientName);
        return (T)concreteSetting.get(settings);
    }
}

