/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.util.SecurityUtils;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageClientSettings;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageHttpStatsCollector;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageOperationsStats;
import org.elasticsearch.repositories.gcs.SocketAccess;

public class GoogleCloudStorageService {
    private static final Logger logger = LogManager.getLogger(GoogleCloudStorageService.class);
    private volatile Map<String, GoogleCloudStorageClientSettings> clientSettings = Collections.emptyMap();
    private volatile Map<String, Storage> clientCache = Collections.emptyMap();

    public synchronized void refreshAndClearCache(Map<String, GoogleCloudStorageClientSettings> clientsSettings) {
        this.clientCache = Collections.emptyMap();
        this.clientSettings = MapBuilder.newMapBuilder(clientsSettings).immutableMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Storage client(String clientName, String repositoryName, GoogleCloudStorageOperationsStats stats) throws IOException {
        Storage storage = this.clientCache.get(repositoryName);
        if (storage != null) {
            return storage;
        }
        GoogleCloudStorageService googleCloudStorageService = this;
        synchronized (googleCloudStorageService) {
            Storage existing = this.clientCache.get(repositoryName);
            if (existing != null) {
                return existing;
            }
            GoogleCloudStorageClientSettings settings = this.clientSettings.get(clientName);
            if (settings == null) {
                throw new IllegalArgumentException("Unknown client name [" + clientName + "]. Existing client configs: " + Strings.collectionToDelimitedString(this.clientSettings.keySet(), (String)","));
            }
            logger.debug(() -> new ParameterizedMessage("creating GCS client with client_name [{}], endpoint [{}]", (Object)clientName, (Object)settings.getHost()));
            Storage storage2 = this.createClient(settings, stats);
            this.clientCache = MapBuilder.newMapBuilder(this.clientCache).put((Object)repositoryName, (Object)storage2).immutableMap();
            return storage2;
        }
    }

    synchronized void closeRepositoryClient(String repositoryName) {
        this.clientCache = MapBuilder.newMapBuilder(this.clientCache).remove((Object)repositoryName).immutableMap();
    }

    private Storage createClient(GoogleCloudStorageClientSettings gcsClientSettings, GoogleCloudStorageOperationsStats stats) throws IOException {
        HttpTransport httpTransport = (HttpTransport)SocketAccess.doPrivilegedIOException(() -> {
            NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
            KeyStore certTrustStore = SecurityUtils.getJavaKeyStore();
            try (InputStream keyStoreStream = GoogleUtils.class.getResourceAsStream("google.jks");){
                SecurityUtils.loadKeyStore((KeyStore)certTrustStore, (InputStream)keyStoreStream, (String)"notasecret");
            }
            builder.trustCertificates(certTrustStore);
            return builder.build();
        });
        final GoogleCloudStorageHttpStatsCollector httpStatsCollector = new GoogleCloudStorageHttpStatsCollector(stats);
        HttpTransportOptions httpTransportOptions = new HttpTransportOptions(HttpTransportOptions.newBuilder().setConnectTimeout(GoogleCloudStorageService.toTimeout(gcsClientSettings.getConnectTimeout()).intValue()).setReadTimeout(GoogleCloudStorageService.toTimeout(gcsClientSettings.getReadTimeout()).intValue()).setHttpTransportFactory(() -> httpTransport)){

            public HttpRequestInitializer getHttpRequestInitializer(ServiceOptions<?, ?> serviceOptions) {
                HttpRequestInitializer requestInitializer = super.getHttpRequestInitializer(serviceOptions);
                return httpRequest -> {
                    if (requestInitializer != null) {
                        requestInitializer.initialize(httpRequest);
                    }
                    httpRequest.setResponseInterceptor((HttpResponseInterceptor)httpStatsCollector);
                };
            }
        };
        StorageOptions storageOptions = this.createStorageOptions(gcsClientSettings, httpTransportOptions);
        return (Storage)storageOptions.getService();
    }

    StorageOptions createStorageOptions(GoogleCloudStorageClientSettings gcsClientSettings, HttpTransportOptions httpTransportOptions) {
        StorageOptions.Builder storageOptionsBuilder = (StorageOptions.Builder)StorageOptions.newBuilder().setTransportOptions((TransportOptions)httpTransportOptions).setHeaderProvider(() -> {
            MapBuilder mapBuilder = MapBuilder.newMapBuilder();
            if (Strings.hasLength((String)gcsClientSettings.getApplicationName())) {
                mapBuilder.put((Object)"user-agent", (Object)gcsClientSettings.getApplicationName());
            }
            return mapBuilder.immutableMap();
        });
        if (Strings.hasLength((String)gcsClientSettings.getHost())) {
            storageOptionsBuilder.setHost(gcsClientSettings.getHost());
        }
        if (Strings.hasLength((String)gcsClientSettings.getProjectId())) {
            storageOptionsBuilder.setProjectId(gcsClientSettings.getProjectId());
        } else {
            String defaultProjectId = null;
            try {
                defaultProjectId = ServiceOptions.getDefaultProjectId();
                if (defaultProjectId != null) {
                    storageOptionsBuilder.setProjectId(defaultProjectId);
                }
            }
            catch (Exception e) {
                logger.warn("failed to load default project id", (Throwable)e);
            }
            if (defaultProjectId == null) {
                try {
                    SocketAccess.doPrivilegedVoidIOException((CheckedRunnable<IOException>)((CheckedRunnable)() -> {
                        String projectId = GoogleCloudStorageService.getDefaultProjectId();
                        if (projectId != null) {
                            storageOptionsBuilder.setProjectId(projectId);
                        }
                    }));
                }
                catch (Exception e) {
                    logger.warn("failed to load default project id fallback", (Throwable)e);
                }
            }
        }
        if (gcsClientSettings.getCredential() == null) {
            try {
                storageOptionsBuilder.setCredentials((Credentials)GoogleCredentials.getApplicationDefault());
            }
            catch (Exception e) {
                logger.warn("failed to load Application Default Credentials", (Throwable)e);
            }
        } else {
            ServiceAccountCredentials serviceAccountCredentials = gcsClientSettings.getCredential();
            URI tokenServerUri = gcsClientSettings.getTokenUri();
            if (Strings.hasLength((String)tokenServerUri.toString())) {
                serviceAccountCredentials = serviceAccountCredentials.toBuilder().setTokenServerUri(tokenServerUri).build();
            }
            storageOptionsBuilder.setCredentials((Credentials)serviceAccountCredentials);
        }
        return storageOptionsBuilder.build();
    }

    @SuppressForbidden(reason="ok to open connection here")
    private static String getDefaultProjectId() throws IOException {
        block12: {
            String metaHost = System.getenv("GCE_METADATA_HOST");
            if (metaHost == null) {
                metaHost = "metadata.google.internal";
            }
            URL url = new URL("http://" + metaHost + "/computeMetadata/v1/project/project-id");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("Metadata-Flavor", "Google");
            try (InputStream input = connection.getInputStream();){
                String string;
                if (connection.getResponseCode() != 200) break block12;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                    string = reader.readLine();
                }
                return string;
            }
        }
        return null;
    }

    static Integer toTimeout(TimeValue timeout) {
        if (timeout == null || TimeValue.ZERO.equals((Object)timeout)) {
            return -1;
        }
        if (TimeValue.MINUS_ONE.equals((Object)timeout)) {
            return 0;
        }
        return Math.toIntExact(timeout.getMillis());
    }
}

