/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetadata;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageBlobStore;

class GoogleCloudStorageBlobContainer
extends AbstractBlobContainer {
    private final GoogleCloudStorageBlobStore blobStore;
    private final String path;

    GoogleCloudStorageBlobContainer(BlobPath path, GoogleCloudStorageBlobStore blobStore) {
        super(path);
        this.blobStore = blobStore;
        this.path = path.buildAsString();
    }

    public boolean blobExists(String blobName) {
        try {
            return this.blobStore.blobExists(this.buildKey(blobName));
        }
        catch (Exception e) {
            throw new BlobStoreException("Failed to check if blob [" + blobName + "] exists", (Throwable)e);
        }
    }

    public Map<String, BlobMetadata> listBlobs() throws IOException {
        return this.blobStore.listBlobs(this.path);
    }

    public Map<String, BlobContainer> children() throws IOException {
        return this.blobStore.listChildren(this.path());
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(String prefix) throws IOException {
        return this.blobStore.listBlobsByPrefix(this.path, prefix);
    }

    public InputStream readBlob(String blobName) throws IOException {
        return this.blobStore.readBlob(this.buildKey(blobName));
    }

    public InputStream readBlob(String blobName, long position, long length) throws IOException {
        return this.blobStore.readBlob(this.buildKey(blobName), position, length);
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.blobStore.writeBlob(this.buildKey(blobName), inputStream, blobSize, failIfAlreadyExists);
    }

    public void writeBlobAtomic(String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        this.writeBlob(blobName, bytes, failIfAlreadyExists);
    }

    public DeleteResult delete() throws IOException {
        return this.blobStore.deleteDirectory(this.path().buildAsString());
    }

    public void deleteBlobsIgnoringIfNotExists(List<String> blobNames) throws IOException {
        this.blobStore.deleteBlobsIgnoringIfNotExists(blobNames.stream().map(this::buildKey).collect(Collectors.toList()));
    }

    private String buildKey(String blobName) {
        assert (blobName != null);
        return this.path + blobName;
    }
}

