/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.ConnectionFactory;
import com.google.api.client.http.javanet.DefaultConnectionFactory;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageClientSettings;
import org.elasticsearch.repositories.gcs.SocketAccess;

public class GoogleCloudStorageService {
    private static final Logger logger = LogManager.getLogger(GoogleCloudStorageService.class);
    private final AtomicReference<Map<String, LazyInitializable<Storage, IOException>>> clientsCache = new AtomicReference(Collections.emptyMap());

    public synchronized void refreshAndClearCache(Map<String, GoogleCloudStorageClientSettings> clientsSettings) {
        MapBuilder newClientsCache = MapBuilder.newMapBuilder();
        for (Map.Entry<String, GoogleCloudStorageClientSettings> entry : clientsSettings.entrySet()) {
            newClientsCache.put((Object)entry.getKey(), (Object)new LazyInitializable(() -> this.createClient((String)entry.getKey(), (GoogleCloudStorageClientSettings)entry.getValue())));
        }
        Map<String, LazyInitializable<Storage, IOException>> oldClientCache = this.clientsCache.getAndSet(newClientsCache.immutableMap());
        oldClientCache.values().forEach(LazyInitializable::reset);
    }

    public Storage client(String clientName) throws IOException {
        LazyInitializable<Storage, IOException> lazyClient = this.clientsCache.get().get(clientName);
        if (lazyClient == null) {
            throw new IllegalArgumentException("Unknown client name [" + clientName + "]. Existing client configs: " + Strings.collectionToDelimitedString(this.clientsCache.get().keySet(), (String)","));
        }
        return (Storage)lazyClient.getOrCompute();
    }

    private Storage createClient(String clientName, GoogleCloudStorageClientSettings clientSettings) throws IOException {
        logger.debug(() -> new ParameterizedMessage("creating GCS client with client_name [{}], endpoint [{}]", (Object)clientName, (Object)clientSettings.getHost()));
        HttpTransport httpTransport = SocketAccess.doPrivilegedIOException(() -> GoogleCloudStorageService.createHttpTransport(clientSettings.getHost()));
        HttpTransportOptions httpTransportOptions = HttpTransportOptions.newBuilder().setConnectTimeout(GoogleCloudStorageService.toTimeout(clientSettings.getConnectTimeout()).intValue()).setReadTimeout(GoogleCloudStorageService.toTimeout(clientSettings.getReadTimeout()).intValue()).setHttpTransportFactory(() -> httpTransport).build();
        StorageOptions.Builder storageOptionsBuilder = (StorageOptions.Builder)StorageOptions.newBuilder().setTransportOptions((TransportOptions)httpTransportOptions).setHeaderProvider(() -> {
            MapBuilder mapBuilder = MapBuilder.newMapBuilder();
            if (Strings.hasLength((String)clientSettings.getApplicationName())) {
                mapBuilder.put((Object)"user-agent", (Object)clientSettings.getApplicationName());
            }
            return mapBuilder.immutableMap();
        });
        if (Strings.hasLength((String)clientSettings.getHost())) {
            storageOptionsBuilder.setHost(clientSettings.getHost());
        }
        if (Strings.hasLength((String)clientSettings.getProjectId())) {
            storageOptionsBuilder.setProjectId(clientSettings.getProjectId());
        }
        if (clientSettings.getCredential() == null) {
            logger.warn("\"Application Default Credentials\" are not supported out of the box. Additional file system permissions have to be granted to the plugin.");
        } else {
            ServiceAccountCredentials serviceAccountCredentials = clientSettings.getCredential();
            URI tokenServerUri = clientSettings.getTokenUri();
            if (Strings.hasLength((String)tokenServerUri.toString())) {
                serviceAccountCredentials = serviceAccountCredentials.toBuilder().setTokenServerUri(tokenServerUri).build();
            }
            storageOptionsBuilder.setCredentials((Credentials)serviceAccountCredentials);
        }
        return (Storage)storageOptionsBuilder.build().getService();
    }

    private static HttpTransport createHttpTransport(String endpoint) throws Exception {
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        builder.trustCertificates(GoogleUtils.getCertificateTrustStore());
        if (Strings.hasLength((String)endpoint)) {
            final URL endpointUrl = URI.create(endpoint).toURL();
            builder.setConnectionFactory((ConnectionFactory)new DefaultConnectionFactory(){

                public HttpURLConnection openConnection(URL originalUrl) throws IOException {
                    URI originalUri;
                    if (originalUrl.getHost().equals(endpointUrl.getHost()) && originalUrl.getPort() == endpointUrl.getPort() && originalUrl.getProtocol().equals(endpointUrl.getProtocol())) {
                        return super.openConnection(originalUrl);
                    }
                    try {
                        originalUri = originalUrl.toURI();
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                    String overridePath = "/";
                    if (originalUri.getRawPath() != null) {
                        overridePath = originalUri.getRawPath();
                    }
                    if (originalUri.getRawQuery() != null) {
                        overridePath = overridePath + "?" + originalUri.getRawQuery();
                    }
                    return super.openConnection(new URL(endpointUrl.getProtocol(), endpointUrl.getHost(), endpointUrl.getPort(), overridePath));
                }
            });
        }
        return builder.build();
    }

    static Integer toTimeout(TimeValue timeout) {
        if (timeout == null || TimeValue.ZERO.equals((Object)timeout)) {
            return -1;
        }
        if (TimeValue.MINUS_ONE.equals((Object)timeout)) {
            return 0;
        }
        return Math.toIntExact(timeout.getMillis());
    }
}

