/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageBlobStore;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageService;

class GoogleCloudStorageRepository
extends BlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(GoogleCloudStorageRepository.class);
    static final ByteSizeValue MIN_CHUNK_SIZE = new ByteSizeValue(1L, ByteSizeUnit.BYTES);
    static final ByteSizeValue MAX_CHUNK_SIZE = new ByteSizeValue(100L, ByteSizeUnit.MB);
    static final String TYPE = "gcs";
    static final Setting<String> BUCKET = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<String> BASE_PATH = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<Boolean> COMPRESS = Setting.boolSetting((String)"compress", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<ByteSizeValue> CHUNK_SIZE = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)MAX_CHUNK_SIZE, (ByteSizeValue)MIN_CHUNK_SIZE, (ByteSizeValue)MAX_CHUNK_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<String> CLIENT_NAME = new Setting("client", "default", Function.identity(), new Setting.Property[0]);
    private final Settings settings;
    private final GoogleCloudStorageService storageService;
    private final BlobPath basePath;
    private final boolean compress;
    private final ByteSizeValue chunkSize;
    private final String bucket;
    private final String clientName;

    GoogleCloudStorageRepository(RepositoryMetaData metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, GoogleCloudStorageService storageService) {
        super(metadata, environment.settings(), namedXContentRegistry);
        this.settings = environment.settings();
        this.storageService = storageService;
        String basePath = (String)BASE_PATH.get(metadata.settings());
        if (Strings.hasLength((String)basePath)) {
            BlobPath path = new BlobPath();
            for (String elem : basePath.split("/")) {
                path = path.add(elem);
            }
            this.basePath = path;
        } else {
            this.basePath = BlobPath.cleanPath();
        }
        this.compress = GoogleCloudStorageRepository.getSetting(COMPRESS, metadata);
        this.chunkSize = GoogleCloudStorageRepository.getSetting(CHUNK_SIZE, metadata);
        this.bucket = GoogleCloudStorageRepository.getSetting(BUCKET, metadata);
        this.clientName = (String)CLIENT_NAME.get(metadata.settings());
        logger.debug("using bucket [{}], base_path [{}], chunk_size [{}], compress [{}]", (Object)this.bucket, (Object)basePath, (Object)this.chunkSize, (Object)this.compress);
    }

    protected GoogleCloudStorageBlobStore createBlobStore() {
        return new GoogleCloudStorageBlobStore(this.bucket, this.clientName, this.storageService);
    }

    protected BlobPath basePath() {
        return this.basePath;
    }

    protected boolean isCompress() {
        return this.compress;
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    static <T> T getSetting(Setting<T> setting, RepositoryMetaData metadata) {
        Object value = setting.get(metadata.settings());
        if (value == null) {
            throw new RepositoryException(metadata.name(), "Setting [" + setting.getKey() + "] is not defined for repository");
        }
        if (value instanceof String && !Strings.hasText((String)((String)value))) {
            throw new RepositoryException(metadata.name(), "Setting [" + setting.getKey() + "] is empty for repository");
        }
        return (T)value;
    }
}

