/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;

public class GoogleCloudStorageClientSettings {
    private static final String PREFIX = "gcs.client.";
    static final Setting.AffixSetting<InputStream> CREDENTIALS_FILE_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"credentials_file", key -> SecureSetting.secureFile((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    static final Setting.AffixSetting<String> ENDPOINT_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"endpoint", key -> new Setting(key, "", s -> s, new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    static final Setting.AffixSetting<TimeValue> CONNECT_TIMEOUT_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"connect_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.ZERO, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    static final Setting.AffixSetting<TimeValue> READ_TIMEOUT_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.ZERO, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    static final Setting.AffixSetting<String> APPLICATION_NAME_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"application_name", key -> new Setting(key, "repository-gcs", s -> s, new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private final GoogleCredential credential;
    private final String endpoint;
    private final TimeValue connectTimeout;
    private final TimeValue readTimeout;
    private final String applicationName;

    GoogleCloudStorageClientSettings(GoogleCredential credential, String endpoint, TimeValue connectTimeout, TimeValue readTimeout, String applicationName) {
        this.credential = credential;
        this.endpoint = endpoint;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.applicationName = applicationName;
    }

    public GoogleCredential getCredential() {
        return this.credential;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public TimeValue getConnectTimeout() {
        return this.connectTimeout;
    }

    public TimeValue getReadTimeout() {
        return this.readTimeout;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public static Map<String, GoogleCloudStorageClientSettings> load(Settings settings) {
        HashMap<String, GoogleCloudStorageClientSettings> clients = new HashMap<String, GoogleCloudStorageClientSettings>();
        for (String clientName : settings.getGroups(PREFIX).keySet()) {
            clients.put(clientName, GoogleCloudStorageClientSettings.getClientSettings(settings, clientName));
        }
        if (!clients.containsKey("default")) {
            clients.put("default", GoogleCloudStorageClientSettings.getClientSettings(settings, "default"));
        }
        return Collections.unmodifiableMap(clients);
    }

    static GoogleCloudStorageClientSettings getClientSettings(Settings settings, String clientName) {
        return new GoogleCloudStorageClientSettings(GoogleCloudStorageClientSettings.loadCredential(settings, clientName), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, ENDPOINT_SETTING), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, CONNECT_TIMEOUT_SETTING), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, READ_TIMEOUT_SETTING), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, APPLICATION_NAME_SETTING));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static GoogleCredential loadCredential(Settings settings, String clientName) {
        try {
            if (!CREDENTIALS_FILE_SETTING.getConcreteSettingForNamespace(clientName).exists(settings)) {
                return null;
            }
            try (InputStream credStream = (InputStream)CREDENTIALS_FILE_SETTING.getConcreteSettingForNamespace(clientName).get(settings);){
                GoogleCredential credential = GoogleCredential.fromStream((InputStream)credStream);
                if (credential.createScopedRequired()) {
                    credential = credential.createScoped(Collections.singleton("https://www.googleapis.com/auth/devstorage.full_control"));
                }
                GoogleCredential googleCredential = credential;
                return googleCredential;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static <T> T getConfigValue(Settings settings, String clientName, Setting.AffixSetting<T> clientSetting) {
        Setting concreteSetting = clientSetting.getConcreteSettingForNamespace(clientName);
        return (T)concreteSetting.get(settings);
    }
}

