/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.services.storage.Storage;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageClientSettings;

public class GoogleCloudStorageService
extends AbstractComponent {
    private final Map<String, GoogleCloudStorageClientSettings> clientsSettings;

    public GoogleCloudStorageService(Environment environment, Map<String, GoogleCloudStorageClientSettings> clientsSettings) {
        super(environment.settings());
        this.clientsSettings = clientsSettings;
    }

    public Storage createClient(String clientName, String application, TimeValue connectTimeout, TimeValue readTimeout) throws Exception {
        GoogleCloudStorageClientSettings clientSettings = this.clientsSettings.get(clientName);
        if (clientSettings == null) {
            throw new IllegalArgumentException("Unknown client name [" + clientName + "]. Existing client configs: " + Strings.collectionToDelimitedString(this.clientsSettings.keySet(), (String)","));
        }
        NetHttpTransport transport = GoogleNetHttpTransport.newTrustedTransport();
        HttpRequestInitializer requestInitializer = GoogleCloudStorageService.createRequestInitializer(clientSettings, connectTimeout, readTimeout);
        Storage.Builder storage = new Storage.Builder((HttpTransport)transport, (JsonFactory)JacksonFactory.getDefaultInstance(), requestInitializer);
        if (Strings.hasText((String)application)) {
            storage.setApplicationName(application);
        } else if (Strings.hasLength((String)clientSettings.getApplicationName())) {
            storage.setApplicationName(clientSettings.getApplicationName());
        }
        if (Strings.hasLength((String)clientSettings.getEndpoint())) {
            storage.setRootUrl(clientSettings.getEndpoint());
        }
        return storage.build();
    }

    static HttpRequestInitializer createRequestInitializer(GoogleCloudStorageClientSettings settings, TimeValue deprecatedConnectTimeout, TimeValue deprecatedReadTimeout) throws IOException {
        GoogleCredential credential = settings.getCredential();
        if (credential == null) {
            credential = GoogleCredential.getApplicationDefault();
        }
        Integer connectTimeout = deprecatedConnectTimeout != null ? GoogleCloudStorageService.toTimeout(deprecatedConnectTimeout) : GoogleCloudStorageService.toTimeout(settings.getConnectTimeout());
        Integer readTimeout = deprecatedReadTimeout != null ? GoogleCloudStorageService.toTimeout(deprecatedReadTimeout) : GoogleCloudStorageService.toTimeout(settings.getReadTimeout());
        return new DefaultHttpRequestInitializer(credential, connectTimeout, readTimeout);
    }

    static Integer toTimeout(TimeValue timeout) {
        if (timeout == null || TimeValue.ZERO.equals((Object)timeout)) {
            return null;
        }
        if (TimeValue.MINUS_ONE.equals((Object)timeout)) {
            return 0;
        }
        return Math.toIntExact(timeout.getMillis());
    }

    static class DefaultHttpRequestInitializer
    implements HttpRequestInitializer {
        private final Integer connectTimeout;
        private final Integer readTimeout;
        private final GoogleCredential credential;

        DefaultHttpRequestInitializer(GoogleCredential credential, Integer connectTimeoutMillis, Integer readTimeoutMillis) {
            this.credential = credential;
            this.connectTimeout = connectTimeoutMillis;
            this.readTimeout = readTimeoutMillis;
        }

        public void initialize(HttpRequest request) {
            if (this.connectTimeout != null) {
                request.setConnectTimeout(this.connectTimeout.intValue());
            }
            if (this.readTimeout != null) {
                request.setReadTimeout(this.readTimeout.intValue());
            }
            request.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)this.newBackOff()));
            request.setInterceptor((HttpExecuteInterceptor)this.credential);
            HttpBackOffUnsuccessfulResponseHandler handler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)this.newBackOff());
            request.setUnsuccessfulResponseHandler((arg_0, arg_1, arg_2) -> this.lambda$initialize$0((HttpUnsuccessfulResponseHandler)handler, arg_0, arg_1, arg_2));
        }

        private ExponentialBackOff newBackOff() {
            return new ExponentialBackOff.Builder().setInitialIntervalMillis(100).setMaxIntervalMillis(6000).setMaxElapsedTimeMillis(900000).setMultiplier(1.5).setRandomizationFactor(0.5).build();
        }

        private /* synthetic */ boolean lambda$initialize$0(HttpUnsuccessfulResponseHandler handler, HttpRequest req, HttpResponse resp, boolean supportsRetry) throws IOException {
            return this.credential.handleResponse(req, resp, supportsRetry) || handler.handleResponse(req, resp, supportsRetry);
        }
    }
}

