/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.services.storage.Storage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;

interface GoogleCloudStorageService {
    public static final String SETTINGS_PREFIX = "gcs.client.";
    public static final Setting.AffixSetting<InputStream> CREDENTIALS_FILE_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"credentials_file", key -> SecureSetting.secureFile((String)key, null, (Setting.Property[])new Setting.Property[0]));

    public Storage createClient(String var1, String var2, TimeValue var3, TimeValue var4) throws Exception;

    public static Map<String, GoogleCredential> loadClientCredentials(Settings settings) {
        Set clientNames = settings.getGroups(SETTINGS_PREFIX).keySet();
        HashMap<String, GoogleCredential> credentials = new HashMap<String, GoogleCredential>();
        for (String clientName : clientNames) {
            Setting concreteSetting = CREDENTIALS_FILE_SETTING.getConcreteSettingForNamespace(clientName);
            try {
                InputStream credStream = (InputStream)concreteSetting.get(settings);
                Throwable throwable = null;
                try {
                    GoogleCredential credential = GoogleCredential.fromStream((InputStream)credStream);
                    if (credential.createScopedRequired()) {
                        credential = credential.createScoped(Collections.singleton("https://www.googleapis.com/auth/devstorage.full_control"));
                    }
                    credentials.put(clientName, credential);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (credStream == null) continue;
                    if (throwable != null) {
                        try {
                            credStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    credStream.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return credentials;
    }

    public static class InternalGoogleCloudStorageService
    extends AbstractComponent
    implements GoogleCloudStorageService {
        private final Map<String, GoogleCredential> credentials;

        InternalGoogleCloudStorageService(Environment environment, Map<String, GoogleCredential> credentials) {
            super(environment.settings());
            this.credentials = credentials;
        }

        @Override
        public Storage createClient(String clientName, String application, TimeValue connectTimeout, TimeValue readTimeout) throws Exception {
            try {
                GoogleCredential credential = this.getCredential(clientName);
                NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
                Storage.Builder storage = new Storage.Builder((HttpTransport)httpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)new DefaultHttpRequestInitializer(credential, connectTimeout, readTimeout));
                storage.setApplicationName(application);
                this.logger.debug("initializing client with service account [{}/{}]", (Object)credential.getServiceAccountId(), (Object)credential.getServiceAccountUser());
                return storage.build();
            }
            catch (IOException e) {
                throw new ElasticsearchException("Error when loading Google Cloud Storage credentials file", (Throwable)e, new Object[0]);
            }
        }

        GoogleCredential getCredential(String clientName) throws IOException {
            GoogleCredential cred = this.credentials.get(clientName);
            if (cred != null) {
                return cred;
            }
            return this.getDefaultCredential();
        }

        GoogleCredential getDefaultCredential() throws IOException {
            return GoogleCredential.getApplicationDefault();
        }

        class DefaultHttpRequestInitializer
        implements HttpRequestInitializer {
            private final TimeValue connectTimeout;
            private final TimeValue readTimeout;
            private final GoogleCredential credential;

            DefaultHttpRequestInitializer(GoogleCredential credential, TimeValue connectTimeout, TimeValue readTimeout) {
                this.credential = credential;
                this.connectTimeout = connectTimeout;
                this.readTimeout = readTimeout;
            }

            public void initialize(HttpRequest request) throws IOException {
                if (this.connectTimeout != null) {
                    request.setConnectTimeout((int)this.connectTimeout.millis());
                }
                if (this.readTimeout != null) {
                    request.setReadTimeout((int)this.readTimeout.millis());
                }
                request.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)this.newBackOff()));
                request.setInterceptor((HttpExecuteInterceptor)this.credential);
                HttpBackOffUnsuccessfulResponseHandler handler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)this.newBackOff());
                request.setUnsuccessfulResponseHandler((arg_0, arg_1, arg_2) -> this.lambda$initialize$0((HttpUnsuccessfulResponseHandler)handler, arg_0, arg_1, arg_2));
            }

            private ExponentialBackOff newBackOff() {
                return new ExponentialBackOff.Builder().setInitialIntervalMillis(100).setMaxIntervalMillis(6000).setMaxElapsedTimeMillis(900000).setMultiplier(1.5).setRandomizationFactor(0.5).build();
            }

            private /* synthetic */ boolean lambda$initialize$0(HttpUnsuccessfulResponseHandler handler, HttpRequest req, HttpResponse resp, boolean supportsRetry) throws IOException {
                return this.credential.handleResponse(req, resp, supportsRetry) || handler.handleResponse(req, resp, supportsRetry);
            }
        }
    }
}

