/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.services.storage.Storage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;

interface GoogleCloudStorageService {
    public static final String SETTINGS_PREFIX = "gcs.client.";
    public static final Setting.AffixSetting<InputStream> CREDENTIALS_FILE_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"credentials_file", key -> SecureSetting.secureFile((String)key, null, (Setting.Property[])new Setting.Property[0]));

    public Storage createClient(String var1, String var2, String var3, TimeValue var4, TimeValue var5) throws Exception;

    public static Map<String, GoogleCredential> loadClientCredentials(Settings settings) {
        Set clientNames = settings.getGroups(SETTINGS_PREFIX).keySet();
        HashMap<String, GoogleCredential> credentials = new HashMap<String, GoogleCredential>();
        for (String clientName : clientNames) {
            Setting concreteSetting = CREDENTIALS_FILE_SETTING.getConcreteSettingForNamespace(clientName);
            try {
                InputStream credStream = (InputStream)concreteSetting.get(settings);
                Throwable throwable = null;
                try {
                    GoogleCredential credential = GoogleCredential.fromStream((InputStream)credStream);
                    if (credential.createScopedRequired()) {
                        credential = credential.createScoped(Collections.singleton("https://www.googleapis.com/auth/devstorage.full_control"));
                    }
                    credentials.put(clientName, credential);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (credStream == null) continue;
                    if (throwable != null) {
                        try {
                            credStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    credStream.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return credentials;
    }

    public static class InternalGoogleCloudStorageService
    extends AbstractComponent
    implements GoogleCloudStorageService {
        private static final String DEFAULT = "_default_";
        private final Environment environment;
        private final Map<String, GoogleCredential> credentials;

        InternalGoogleCloudStorageService(Environment environment, Map<String, GoogleCredential> credentials) {
            super(environment.settings());
            this.environment = environment;
            this.credentials = credentials;
        }

        @Override
        public Storage createClient(String serviceAccountFile, String clientName, String application, TimeValue connectTimeout, TimeValue readTimeout) throws Exception {
            try {
                GoogleCredential credential = this.getCredential(serviceAccountFile, clientName);
                NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
                Storage.Builder storage = new Storage.Builder((HttpTransport)httpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)new DefaultHttpRequestInitializer(credential, connectTimeout, readTimeout));
                storage.setApplicationName(application);
                this.logger.debug("initializing client with service account [{}/{}]", (Object)credential.getServiceAccountId(), (Object)credential.getServiceAccountUser());
                return storage.build();
            }
            catch (IOException e) {
                throw new ElasticsearchException("Error when loading Google Cloud Storage credentials file", (Throwable)e, new Object[0]);
            }
        }

        GoogleCredential getCredential(String serviceAccountFile, String clientName) throws IOException {
            if (!DEFAULT.equalsIgnoreCase(serviceAccountFile)) {
                this.deprecationLogger.deprecated("Using GCS service account file from disk is deprecated. Move the file into the elasticsearch keystore.", new Object[0]);
                Path account = this.environment.configFile().resolve(serviceAccountFile);
                if (!Files.exists(account, new LinkOption[0])) {
                    throw new IllegalArgumentException("Unable to find service account file [" + serviceAccountFile + "] defined for repository");
                }
                try (InputStream is = Files.newInputStream(account, new OpenOption[0]);){
                    GoogleCredential credential = GoogleCredential.fromStream((InputStream)is);
                    if (credential.createScopedRequired()) {
                        credential = credential.createScoped(Collections.singleton("https://www.googleapis.com/auth/devstorage.full_control"));
                    }
                    GoogleCredential googleCredential = credential;
                    return googleCredential;
                }
            }
            if (this.credentials.containsKey(clientName)) {
                return this.credentials.get(clientName);
            }
            return this.getDefaultCredential();
        }

        GoogleCredential getDefaultCredential() throws IOException {
            return GoogleCredential.getApplicationDefault();
        }

        class DefaultHttpRequestInitializer
        implements HttpRequestInitializer {
            private final TimeValue connectTimeout;
            private final TimeValue readTimeout;
            private final GoogleCredential credential;
            private final HttpUnsuccessfulResponseHandler handler;
            private final HttpIOExceptionHandler ioHandler;

            DefaultHttpRequestInitializer(GoogleCredential credential, TimeValue connectTimeout, TimeValue readTimeout) {
                this.credential = credential;
                this.connectTimeout = connectTimeout;
                this.readTimeout = readTimeout;
                this.handler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)this.newBackOff());
                this.ioHandler = new HttpBackOffIOExceptionHandler((BackOff)this.newBackOff());
            }

            public void initialize(HttpRequest request) throws IOException {
                if (this.connectTimeout != null) {
                    request.setConnectTimeout((int)this.connectTimeout.millis());
                }
                if (this.readTimeout != null) {
                    request.setReadTimeout((int)this.readTimeout.millis());
                }
                request.setIOExceptionHandler(this.ioHandler);
                request.setInterceptor((HttpExecuteInterceptor)this.credential);
                request.setUnsuccessfulResponseHandler((req, resp, supportsRetry) -> this.credential.handleResponse(req, resp, supportsRetry) || this.handler.handleResponse(req, resp, supportsRetry));
            }

            private ExponentialBackOff newBackOff() {
                return new ExponentialBackOff.Builder().setInitialIntervalMillis(100).setMaxIntervalMillis(6000).setMaxElapsedTimeMillis(900000).setMultiplier(1.5).setRandomizationFactor(0.5).build();
            }
        }
    }
}

