/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.api.services.storage.Storage;
import java.util.function.Function;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageBlobStore;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageService;

class GoogleCloudStorageRepository
extends BlobStoreRepository {
    static final ByteSizeValue MIN_CHUNK_SIZE = new ByteSizeValue(1L, ByteSizeUnit.BYTES);
    static final ByteSizeValue MAX_CHUNK_SIZE = new ByteSizeValue(100L, ByteSizeUnit.MB);
    static final String TYPE = "gcs";
    static final TimeValue NO_TIMEOUT = TimeValue.timeValueMillis((long)-1L);
    static final Setting<String> BUCKET = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<String> BASE_PATH = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<Boolean> COMPRESS = Setting.boolSetting((String)"compress", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<ByteSizeValue> CHUNK_SIZE = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)MAX_CHUNK_SIZE, (ByteSizeValue)MIN_CHUNK_SIZE, (ByteSizeValue)MAX_CHUNK_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<String> APPLICATION_NAME = new Setting("application_name", "repository-gcs", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<String> SERVICE_ACCOUNT = new Setting("service_account", "_default_", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Deprecated});
    static final Setting<String> CLIENT_NAME = new Setting("client", "default", Function.identity(), new Setting.Property[0]);
    static final Setting<TimeValue> HTTP_READ_TIMEOUT = Setting.timeSetting((String)"http.read_timeout", (TimeValue)NO_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<TimeValue> HTTP_CONNECT_TIMEOUT = Setting.timeSetting((String)"http.connect_timeout", (TimeValue)NO_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final ByteSizeValue chunkSize;
    private final boolean compress;
    private final BlobPath basePath;
    private final GoogleCloudStorageBlobStore blobStore;

    GoogleCloudStorageRepository(RepositoryMetaData metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, GoogleCloudStorageService storageService) throws Exception {
        super(metadata, environment.settings(), namedXContentRegistry);
        String bucket = GoogleCloudStorageRepository.getSetting(BUCKET, metadata);
        String application = GoogleCloudStorageRepository.getSetting(APPLICATION_NAME, metadata);
        String serviceAccount = (String)SERVICE_ACCOUNT.get(metadata.settings());
        String clientName = (String)CLIENT_NAME.get(metadata.settings());
        String basePath = (String)BASE_PATH.get(metadata.settings());
        if (Strings.hasLength((String)basePath)) {
            BlobPath path = new BlobPath();
            for (String elem : basePath.split("/")) {
                path = path.add(elem);
            }
            this.basePath = path;
        } else {
            this.basePath = BlobPath.cleanPath();
        }
        TimeValue connectTimeout = null;
        TimeValue readTimeout = null;
        TimeValue timeout = (TimeValue)HTTP_CONNECT_TIMEOUT.get(metadata.settings());
        if (timeout != null && timeout.millis() != NO_TIMEOUT.millis()) {
            connectTimeout = timeout;
        }
        if ((timeout = (TimeValue)HTTP_READ_TIMEOUT.get(metadata.settings())) != null && timeout.millis() != NO_TIMEOUT.millis()) {
            readTimeout = timeout;
        }
        this.compress = GoogleCloudStorageRepository.getSetting(COMPRESS, metadata);
        this.chunkSize = GoogleCloudStorageRepository.getSetting(CHUNK_SIZE, metadata);
        this.logger.debug("using bucket [{}], base_path [{}], chunk_size [{}], compress [{}], application [{}]", (Object)bucket, (Object)basePath, (Object)this.chunkSize, (Object)this.compress, (Object)application);
        Storage client = storageService.createClient(serviceAccount, clientName, application, connectTimeout, readTimeout);
        this.blobStore = new GoogleCloudStorageBlobStore(this.settings, bucket, client);
    }

    protected BlobStore blobStore() {
        return this.blobStore;
    }

    protected BlobPath basePath() {
        return this.basePath;
    }

    protected boolean isCompress() {
        return this.compress;
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    static <T> T getSetting(Setting<T> setting, RepositoryMetaData metadata) {
        Object value = setting.get(metadata.settings());
        if (value == null) {
            throw new RepositoryException(metadata.name(), "Setting [" + setting.getKey() + "] is not defined for repository");
        }
        if (value instanceof String && !Strings.hasText((String)((String)value))) {
            throw new RepositoryException(metadata.name(), "Setting [" + setting.getKey() + "] is empty for repository");
        }
        return (T)value;
    }
}

