/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.services.storage.Storage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;

public interface GoogleCloudStorageService {
    public Storage createClient(String var1, String var2, TimeValue var3, TimeValue var4) throws Exception;

    public static class InternalGoogleCloudStorageService
    extends AbstractComponent
    implements GoogleCloudStorageService {
        private static final String DEFAULT = "_default_";
        private final Environment environment;

        public InternalGoogleCloudStorageService(Environment environment) {
            super(environment.settings());
            this.environment = environment;
        }

        @Override
        public Storage createClient(String serviceAccount, String application, TimeValue connectTimeout, TimeValue readTimeout) throws Exception {
            try {
                GoogleCredential credentials = DEFAULT.equalsIgnoreCase(serviceAccount) ? this.loadDefault() : this.loadCredentials(serviceAccount);
                NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
                Storage.Builder storage = new Storage.Builder((HttpTransport)httpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)new DefaultHttpRequestInitializer(credentials, connectTimeout, readTimeout));
                storage.setApplicationName(application);
                this.logger.debug("initializing client with service account [{}/{}]", (Object)credentials.getServiceAccountId(), (Object)credentials.getServiceAccountUser());
                return storage.build();
            }
            catch (IOException e) {
                throw new ElasticsearchException("Error when loading Google Cloud Storage credentials file", (Throwable)e, new Object[0]);
            }
        }

        private GoogleCredential loadCredentials(String serviceAccount) throws IOException {
            if (serviceAccount == null) {
                throw new ElasticsearchException("Cannot load Google Cloud Storage service account file from a null path", new Object[0]);
            }
            Path account = this.environment.configFile().resolve(serviceAccount);
            if (!Files.exists(account, new LinkOption[0])) {
                throw new ElasticsearchException("Unable to find service account file [" + serviceAccount + "] defined for repository", new Object[0]);
            }
            try (InputStream is = Files.newInputStream(account, new OpenOption[0]);){
                GoogleCredential credential = GoogleCredential.fromStream((InputStream)is);
                if (credential.createScopedRequired()) {
                    credential = credential.createScoped(Collections.singleton("https://www.googleapis.com/auth/devstorage.full_control"));
                }
                GoogleCredential googleCredential = credential;
                return googleCredential;
            }
        }

        private GoogleCredential loadDefault() throws IOException {
            return GoogleCredential.getApplicationDefault();
        }

        class DefaultHttpRequestInitializer
        implements HttpRequestInitializer {
            private final TimeValue connectTimeout;
            private final TimeValue readTimeout;
            private final GoogleCredential credential;
            private final HttpUnsuccessfulResponseHandler handler;
            private final HttpIOExceptionHandler ioHandler;

            DefaultHttpRequestInitializer(GoogleCredential credential, TimeValue connectTimeout, TimeValue readTimeout) {
                this.credential = credential;
                this.connectTimeout = connectTimeout;
                this.readTimeout = readTimeout;
                this.handler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)this.newBackOff());
                this.ioHandler = new HttpBackOffIOExceptionHandler((BackOff)this.newBackOff());
            }

            public void initialize(HttpRequest request) throws IOException {
                if (this.connectTimeout != null) {
                    request.setConnectTimeout((int)this.connectTimeout.millis());
                }
                if (this.readTimeout != null) {
                    request.setReadTimeout((int)this.readTimeout.millis());
                }
                request.setIOExceptionHandler(this.ioHandler);
                request.setInterceptor((HttpExecuteInterceptor)this.credential);
                request.setUnsuccessfulResponseHandler((req, resp, supportsRetry) -> this.credential.handleResponse(req, resp, supportsRetry) || this.handler.handleResponse(req, resp, supportsRetry));
            }

            private ExponentialBackOff newBackOff() {
                return new ExponentialBackOff.Builder().setInitialIntervalMillis(100).setMaxIntervalMillis(6000).setMaxElapsedTimeMillis(900000).setMultiplier(1.5).setRandomizationFactor(0.5).build();
            }
        }
    }
}

