/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import com.microsoft.azure.storage.LocationMode;
import com.microsoft.azure.storage.StorageException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.cloud.azure.blobstore.AzureBlobStore;
import org.elasticsearch.cloud.azure.storage.AzureStorageService;
import org.elasticsearch.cloud.azure.storage.AzureStorageSettings;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.snapshots.SnapshotCreationException;
import org.elasticsearch.snapshots.SnapshotId;

public class AzureRepository
extends BlobStoreRepository {
    public static final String TYPE = "azure";
    private final AzureBlobStore blobStore;
    private final BlobPath basePath;
    private final ByteSizeValue chunkSize;
    private final boolean compress;
    private final boolean readonly;

    public AzureRepository(RepositoryMetaData metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, AzureStorageService storageService) throws IOException, URISyntaxException, StorageException {
        super(metadata, environment.settings(), namedXContentRegistry);
        LocationMode locationMode;
        this.blobStore = new AzureBlobStore(metadata, environment.settings(), storageService);
        String container = AzureStorageSettings.getValue(metadata.settings(), this.settings, Repository.CONTAINER_SETTING, AzureStorageService.Storage.CONTAINER_SETTING);
        this.chunkSize = AzureStorageSettings.getValue(metadata.settings(), this.settings, Repository.CHUNK_SIZE_SETTING, AzureStorageService.Storage.CHUNK_SIZE_SETTING);
        this.compress = AzureStorageSettings.getValue(metadata.settings(), this.settings, Repository.COMPRESS_SETTING, AzureStorageService.Storage.COMPRESS_SETTING);
        String modeStr = AzureStorageSettings.getValue(metadata.settings(), this.settings, Repository.LOCATION_MODE_SETTING, AzureStorageService.Storage.LOCATION_MODE_SETTING);
        Boolean forcedReadonly = metadata.settings().getAsBoolean("readonly", null);
        this.readonly = forcedReadonly == null ? (Strings.hasLength((String)modeStr) ? (locationMode = LocationMode.valueOf((String)modeStr.toUpperCase(Locale.ROOT))) == LocationMode.SECONDARY_ONLY : false) : forcedReadonly;
        String basePath = AzureStorageSettings.getValue(metadata.settings(), this.settings, Repository.BASE_PATH_SETTING, AzureStorageService.Storage.BASE_PATH_SETTING);
        if (Strings.hasLength((String)basePath)) {
            basePath = Strings.trimLeadingCharacter((String)basePath, (char)'/');
            BlobPath path = new BlobPath();
            for (String elem : basePath.split("/")) {
                path = path.add(elem);
            }
            this.basePath = path;
        } else {
            this.basePath = BlobPath.cleanPath();
        }
        this.logger.debug("using container [{}], chunk_size [{}], compress [{}], base_path [{}]", (Object)container, (Object)this.chunkSize, (Object)this.compress, (Object)basePath);
    }

    protected BlobStore blobStore() {
        return this.blobStore;
    }

    protected BlobPath basePath() {
        return this.basePath;
    }

    protected boolean isCompress() {
        return this.compress;
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    public void initializeSnapshot(SnapshotId snapshotId, List<IndexId> indices, MetaData clusterMetadata) {
        try {
            if (!this.blobStore.doesContainerExist(this.blobStore.container())) {
                this.logger.debug("container [{}] does not exist. Creating...", (Object)this.blobStore.container());
                this.deprecationLogger.deprecated("Auto creation of the container for an azure backed repository is deprecated and will be removed in 6.0.", new Object[0]);
                this.blobStore.createContainer(this.blobStore.container());
            }
            super.initializeSnapshot(snapshotId, indices, clusterMetadata);
        }
        catch (StorageException | URISyntaxException e) {
            this.logger.warn("can not initialize container [{}]: [{}]", (Object)this.blobStore.container(), (Object)e.getMessage());
            throw new SnapshotCreationException(this.getMetadata().name(), snapshotId, e);
        }
    }

    public String startVerification() {
        if (!this.readonly) {
            try {
                if (!this.blobStore.doesContainerExist(this.blobStore.container())) {
                    this.logger.debug("container [{}] does not exist. Creating...", (Object)this.blobStore.container());
                    this.deprecationLogger.deprecated("Auto creation of the container for an azure backed repository is deprecated and will be removed in 6.0.", new Object[0]);
                    this.blobStore.createContainer(this.blobStore.container());
                }
            }
            catch (StorageException | URISyntaxException e) {
                this.logger.warn("can not initialize container [{}]: [{}]", (Object)this.blobStore.container(), (Object)e.getMessage());
                throw new RepositoryVerificationException(this.getMetadata().name(), "can not initialize container " + this.blobStore.container(), e);
            }
        }
        return super.startVerification();
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public static final class Repository {
        public static final Setting<String> ACCOUNT_SETTING = Setting.simpleString((String)"account", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> CONTAINER_SETTING = new Setting("container", "elasticsearch-snapshots", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> LOCATION_MODE_SETTING = Setting.simpleString((String)"location_mode", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)AzureStorageService.MAX_CHUNK_SIZE, (ByteSizeValue)AzureStorageService.MIN_CHUNK_SIZE, (ByteSizeValue)AzureStorageService.MAX_CHUNK_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting((String)"compress", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    }
}

