/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.azure.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cloud.azure.storage.AzureStorageService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.TimeValue;

public final class AzureStorageSettings {
    private static final Setting<TimeValue> TIMEOUT_SETTING = Setting.affixKeySetting((String)"cloud.azure.storage.", (String)"timeout", key -> Setting.timeSetting((String)key, AzureStorageService.Storage.TIMEOUT_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    private static final Setting<String> ACCOUNT_SETTING = Setting.affixKeySetting((String)"cloud.azure.storage.", (String)"account", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    private static final Setting<String> KEY_SETTING = Setting.affixKeySetting((String)"cloud.azure.storage.", (String)"key", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    private static final Setting<Boolean> DEFAULT_SETTING = Setting.affixKeySetting((String)"cloud.azure.storage.", (String)"default", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    private final String name;
    private final String account;
    private final String key;
    private final TimeValue timeout;
    private final boolean activeByDefault;

    public AzureStorageSettings(String name, String account, String key, TimeValue timeout, boolean activeByDefault) {
        this.name = name;
        this.account = account;
        this.key = key;
        this.timeout = timeout;
        this.activeByDefault = activeByDefault;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getAccount() {
        return this.account;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public boolean isActiveByDefault() {
        return this.activeByDefault;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AzureStorageSettings{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", account='").append(this.account).append('\'');
        sb.append(", key='").append(this.key).append('\'');
        sb.append(", activeByDefault='").append(this.activeByDefault).append('\'');
        sb.append(", timeout=").append(this.timeout);
        sb.append('}');
        return sb.toString();
    }

    public static Tuple<AzureStorageSettings, Map<String, AzureStorageSettings>> parse(Settings settings) {
        List<AzureStorageSettings> storageSettings = AzureStorageSettings.createStorageSettings(settings);
        return Tuple.tuple((Object)AzureStorageSettings.getPrimary(storageSettings), AzureStorageSettings.getSecondaries(storageSettings));
    }

    private static List<AzureStorageSettings> createStorageSettings(Settings settings) {
        Settings groups = (Settings)AzureStorageService.Storage.STORAGE_ACCOUNTS.get(settings.filter(k -> !k.equals(AzureStorageService.Storage.TIMEOUT_SETTING.getKey())));
        ArrayList<AzureStorageSettings> storageSettings = new ArrayList<AzureStorageSettings>();
        for (String groupName : groups.getAsGroups().keySet()) {
            storageSettings.add(new AzureStorageSettings(groupName, AzureStorageSettings.getValue(settings, groupName, ACCOUNT_SETTING), AzureStorageSettings.getValue(settings, groupName, KEY_SETTING), AzureStorageSettings.getValue(settings, groupName, TIMEOUT_SETTING), AzureStorageSettings.getValue(settings, groupName, DEFAULT_SETTING)));
        }
        return storageSettings;
    }

    private static <T> T getValue(Settings settings, String groupName, Setting<T> setting) {
        Setting.AffixKey k = (Setting.AffixKey)setting.getRawKey();
        String fullKey = k.toConcreteKey(groupName).toString();
        return (T)setting.getConcreteSetting(fullKey).get(settings);
    }

    private static AzureStorageSettings getPrimary(List<AzureStorageSettings> settings) {
        if (settings.isEmpty()) {
            return null;
        }
        if (settings.size() == 1) {
            AzureStorageSettings storage = settings.get(0);
            return new AzureStorageSettings(storage.getName(), storage.getAccount(), storage.getKey(), storage.getTimeout(), true);
        }
        AzureStorageSettings primary = null;
        for (AzureStorageSettings setting : settings) {
            if (!setting.isActiveByDefault()) continue;
            if (primary == null) {
                primary = setting;
                continue;
            }
            throw new SettingsException("Multiple default Azure data stores configured: [" + primary.getName() + "] and [" + setting.getName() + "]");
        }
        if (primary == null) {
            throw new SettingsException("No default Azure data store configured");
        }
        return primary;
    }

    private static Map<String, AzureStorageSettings> getSecondaries(List<AzureStorageSettings> settings) {
        HashMap<String, AzureStorageSettings> secondaries = new HashMap<String, AzureStorageSettings>();
        if (settings.size() > 1) {
            for (AzureStorageSettings setting : settings) {
                if (setting.isActiveByDefault()) continue;
                secondaries.put(setting.getName(), setting);
            }
        }
        return Collections.unmodifiableMap(secondaries);
    }

    public static <T> T getValue(Settings repositorySettings, Settings globalSettings, Setting<T> repositorySetting, Setting<T> repositoriesSetting) {
        if (repositorySetting.exists(repositorySettings)) {
            return (T)repositorySetting.get(repositorySettings);
        }
        return (T)repositoriesSetting.get(globalSettings);
    }

    public static <T> Setting<T> getEffectiveSetting(Settings repositorySettings, Setting<T> repositorySetting, Setting<T> repositoriesSetting) {
        if (repositorySetting.exists(repositorySettings)) {
            return repositorySetting;
        }
        return repositoriesSetting;
    }
}

