/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.azure.blobstore;

import com.microsoft.azure.storage.LocationMode;
import com.microsoft.azure.storage.StorageException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.cloud.azure.blobstore.AzureBlobContainer;
import org.elasticsearch.cloud.azure.storage.AzureStorageService;
import org.elasticsearch.cloud.azure.storage.AzureStorageSettings;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.azure.AzureRepository;

public class AzureBlobStore
extends AbstractComponent
implements BlobStore {
    private final AzureStorageService client;
    private final String accountName;
    private final LocationMode locMode;
    private final String container;
    private final String repositoryName;

    public AzureBlobStore(RepositoryMetaData metadata, Settings settings, AzureStorageService client) throws URISyntaxException, StorageException {
        super(settings);
        this.client = client;
        this.container = AzureStorageSettings.getValue(metadata.settings(), settings, AzureRepository.Repository.CONTAINER_SETTING, AzureStorageService.Storage.CONTAINER_SETTING);
        this.repositoryName = metadata.name();
        this.accountName = AzureStorageSettings.getValue(metadata.settings(), settings, AzureRepository.Repository.ACCOUNT_SETTING, AzureStorageService.Storage.ACCOUNT_SETTING);
        String modeStr = AzureStorageSettings.getValue(metadata.settings(), settings, AzureRepository.Repository.LOCATION_MODE_SETTING, AzureStorageService.Storage.LOCATION_MODE_SETTING);
        this.locMode = Strings.hasLength((String)modeStr) ? LocationMode.valueOf((String)modeStr.toUpperCase(Locale.ROOT)) : LocationMode.PRIMARY_ONLY;
    }

    public String toString() {
        return this.container;
    }

    public String container() {
        return this.container;
    }

    public LocationMode getLocationMode() {
        return this.locMode;
    }

    public BlobContainer blobContainer(BlobPath path) {
        return new AzureBlobContainer(this.repositoryName, path, this);
    }

    public void delete(BlobPath path) {
        String keyPath = path.buildAsString();
        try {
            this.client.deleteFiles(this.accountName, this.locMode, this.container, keyPath);
        }
        catch (StorageException | URISyntaxException e) {
            this.logger.warn("can not remove [{}] in container {{}}: {}", (Object)keyPath, (Object)this.container, (Object)e.getMessage());
        }
    }

    public void close() {
    }

    public boolean doesContainerExist(String container) {
        return this.client.doesContainerExist(this.accountName, this.locMode, container);
    }

    public void removeContainer(String container) throws URISyntaxException, StorageException {
        this.client.removeContainer(this.accountName, this.locMode, container);
    }

    public void createContainer(String container) throws URISyntaxException, StorageException {
        this.client.createContainer(this.accountName, this.locMode, container);
    }

    public void deleteFiles(String container, String path) throws URISyntaxException, StorageException {
        this.client.deleteFiles(this.accountName, this.locMode, container, path);
    }

    public boolean blobExists(String container, String blob) throws URISyntaxException, StorageException {
        return this.client.blobExists(this.accountName, this.locMode, container, blob);
    }

    public void deleteBlob(String container, String blob) throws URISyntaxException, StorageException {
        this.client.deleteBlob(this.accountName, this.locMode, container, blob);
    }

    public InputStream getInputStream(String container, String blob) throws URISyntaxException, StorageException, IOException {
        return this.client.getInputStream(this.accountName, this.locMode, container, blob);
    }

    public OutputStream getOutputStream(String container, String blob) throws URISyntaxException, StorageException {
        return this.client.getOutputStream(this.accountName, this.locMode, container, blob);
    }

    public Map<String, BlobMetaData> listBlobsByPrefix(String container, String keyPath, String prefix) throws URISyntaxException, StorageException {
        return this.client.listBlobsByPrefix(this.accountName, this.locMode, container, keyPath, prefix);
    }

    public void moveBlob(String container, String sourceBlob, String targetBlob) throws URISyntaxException, StorageException {
        this.client.moveBlob(this.accountName, this.locMode, container, sourceBlob, targetBlob);
    }
}

