/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RetryContext;
import com.microsoft.azure.storage.RetryInfo;
import com.microsoft.azure.storage.RetryPolicy;
import com.microsoft.azure.storage.RetryPolicyFactory;
import java.util.Random;

public final class RetryExponentialRetry
extends RetryPolicy
implements RetryPolicyFactory {
    private final Random randRef = new Random();
    private int resolvedMaxBackoff = 90000;
    private int resolvedMinBackoff = 3000;

    public RetryExponentialRetry() {
        this(30000, 3);
    }

    public RetryExponentialRetry(int deltaBackoff, int maxAttempts) {
        super(deltaBackoff, maxAttempts);
    }

    public RetryExponentialRetry(int minBackoff, int deltaBackoff, int maxBackOff, int maxAttempts) {
        super(deltaBackoff, maxAttempts);
        this.resolvedMinBackoff = minBackoff;
        this.resolvedMaxBackoff = maxBackOff;
    }

    @Override
    public RetryPolicy createInstance(OperationContext opContext) {
        return new RetryExponentialRetry(this.resolvedMinBackoff, this.deltaBackoffIntervalInMs, this.resolvedMaxBackoff, this.maximumAttempts);
    }

    @Override
    public RetryInfo evaluate(RetryContext retryContext, OperationContext operationContext) {
        boolean secondaryNotFound = this.evaluateLastAttemptAndSecondaryNotFound(retryContext);
        if (retryContext.getCurrentRetryCount() < this.maximumAttempts) {
            int statusCode = retryContext.getLastRequestResult().getStatusCode();
            if (!secondaryNotFound && statusCode >= 400 && statusCode < 500 || statusCode == 501 || statusCode == 505 || statusCode == 306) {
                return null;
            }
            double incrementDelta = Math.pow(2.0, retryContext.getCurrentRetryCount()) - 1.0;
            int boundedRandDelta = (int)((double)this.deltaBackoffIntervalInMs * 0.8) + this.randRef.nextInt((int)((double)this.deltaBackoffIntervalInMs * 1.2) - (int)((double)this.deltaBackoffIntervalInMs * 0.8));
            long retryInterval = (int)Math.round(Math.min((double)this.resolvedMinBackoff + (incrementDelta *= (double)boundedRandDelta), (double)this.resolvedMaxBackoff));
            return this.evaluateRetryInfo(retryContext, secondaryNotFound, retryInterval);
        }
        return null;
    }
}

