/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.repository.azure;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cloud.azure.storage.AzureStorageService;
import org.elasticsearch.cloud.azure.storage.AzureStorageServiceImpl;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.azure.AzureRepository;

public class AzureRepositoryPlugin
extends Plugin
implements RepositoryPlugin {
    protected AzureStorageService createStorageService(Settings settings) {
        return new AzureStorageServiceImpl(settings);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry) {
        return Collections.singletonMap("azure", metadata -> new AzureRepository(metadata, env, namedXContentRegistry, this.createStorageService(env.settings())));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(AzureStorageService.Storage.STORAGE_ACCOUNTS, AzureStorageService.Storage.ACCOUNT_SETTING, AzureStorageService.Storage.COMPRESS_SETTING, AzureStorageService.Storage.CONTAINER_SETTING, AzureStorageService.Storage.BASE_PATH_SETTING, AzureStorageService.Storage.CHUNK_SIZE_SETTING, AzureStorageService.Storage.LOCATION_MODE_SETTING);
    }

    public List<String> getSettingsFilter() {
        return Arrays.asList("cloud.azure.storage.*.account", "cloud.azure.storage.*.key");
    }
}

