/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.azure.storage;

import com.microsoft.azure.storage.LocationMode;
import com.microsoft.azure.storage.StorageException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public interface AzureStorageService {
    public static final ByteSizeValue MIN_CHUNK_SIZE = new ByteSizeValue(1L, ByteSizeUnit.BYTES);
    public static final ByteSizeValue MAX_CHUNK_SIZE = new ByteSizeValue(64L, ByteSizeUnit.MB);

    public boolean doesContainerExist(String var1, LocationMode var2, String var3);

    public void removeContainer(String var1, LocationMode var2, String var3) throws URISyntaxException, StorageException;

    public void createContainer(String var1, LocationMode var2, String var3) throws URISyntaxException, StorageException;

    public void deleteFiles(String var1, LocationMode var2, String var3, String var4) throws URISyntaxException, StorageException;

    public boolean blobExists(String var1, LocationMode var2, String var3, String var4) throws URISyntaxException, StorageException;

    public void deleteBlob(String var1, LocationMode var2, String var3, String var4) throws URISyntaxException, StorageException;

    public InputStream getInputStream(String var1, LocationMode var2, String var3, String var4) throws URISyntaxException, StorageException, IOException;

    public OutputStream getOutputStream(String var1, LocationMode var2, String var3, String var4) throws URISyntaxException, StorageException;

    public Map<String, BlobMetaData> listBlobsByPrefix(String var1, LocationMode var2, String var3, String var4, String var5) throws URISyntaxException, StorageException;

    public void moveBlob(String var1, LocationMode var2, String var3, String var4, String var5) throws URISyntaxException, StorageException;

    public static final class Storage {
        public static final String PREFIX = "cloud.azure.storage.";
        public static final Setting<Settings> STORAGE_ACCOUNTS = Setting.groupSetting((String)"cloud.azure.storage.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<TimeValue> TIMEOUT_SETTING = Setting.timeSetting((String)"cloud.azure.storage.timeout", (TimeValue)TimeValue.timeValueMinutes((long)-1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> ACCOUNT_SETTING = Setting.simpleString((String)"repositories.azure.account", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        public static final Setting<String> CONTAINER_SETTING = new Setting("repositories.azure.container", "elasticsearch-snapshots", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"repositories.azure.base_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> LOCATION_MODE_SETTING = Setting.simpleString((String)"repositories.azure.location_mode", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"repositories.azure.chunk_size", (ByteSizeValue)MAX_CHUNK_SIZE, (ByteSizeValue)MIN_CHUNK_SIZE, (ByteSizeValue)MAX_CHUNK_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting((String)"repositories.azure.compress", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    }
}

