/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.azure.blobstore;

import com.microsoft.azure.storage.LocationMode;
import com.microsoft.azure.storage.StorageException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cloud.azure.blobstore.AzureBlobStore;
import org.elasticsearch.cloud.azure.blobstore.AzureOutputStream;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.repositories.RepositoryException;

public class AzureBlobContainer
extends AbstractBlobContainer {
    protected final Logger logger = Loggers.getLogger(AzureBlobContainer.class);
    protected final AzureBlobStore blobStore;
    protected final String keyPath;
    protected final String repositoryName;

    public AzureBlobContainer(String repositoryName, BlobPath path, AzureBlobStore blobStore) {
        super(path);
        this.blobStore = blobStore;
        this.keyPath = path.buildAsString();
        this.repositoryName = repositoryName;
    }

    public boolean blobExists(String blobName) {
        this.logger.trace("blobExists({})", (Object)blobName);
        try {
            return this.blobStore.blobExists(this.blobStore.container(), this.buildKey(blobName));
        }
        catch (StorageException | URISyntaxException e) {
            this.logger.warn("can not access [{}] in container {{}}: {}", (Object)blobName, (Object)this.blobStore.container(), (Object)e.getMessage());
            return false;
        }
    }

    public InputStream readBlob(String blobName) throws IOException {
        this.logger.trace("readBlob({})", (Object)blobName);
        if (this.blobStore.getLocationMode() == LocationMode.SECONDARY_ONLY && !this.blobExists(blobName)) {
            throw new NoSuchFileException("Blob [" + blobName + "] does not exist");
        }
        try {
            return this.blobStore.getInputStream(this.blobStore.container(), this.buildKey(blobName));
        }
        catch (StorageException e) {
            if (e.getHttpStatusCode() == 404) {
                throw new NoSuchFileException(e.getMessage());
            }
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize) throws IOException {
        if (this.blobExists(blobName)) {
            throw new FileAlreadyExistsException("blob [" + blobName + "] already exists, cannot overwrite");
        }
        this.logger.trace("writeBlob({}, stream, {})", (Object)blobName, (Object)blobSize);
        try (OutputStream stream = this.createOutput(blobName);){
            Streams.copy((InputStream)inputStream, (OutputStream)stream);
        }
    }

    private OutputStream createOutput(String blobName) throws IOException {
        try {
            return new AzureOutputStream(this.blobStore.getOutputStream(this.blobStore.container(), this.buildKey(blobName)));
        }
        catch (StorageException e) {
            if (e.getHttpStatusCode() == 404) {
                throw new NoSuchFileException(e.getMessage());
            }
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException(this.repositoryName, e.getMessage());
        }
    }

    public void deleteBlob(String blobName) throws IOException {
        this.logger.trace("deleteBlob({})", (Object)blobName);
        if (!this.blobExists(blobName)) {
            throw new NoSuchFileException("Blob [" + blobName + "] does not exist");
        }
        try {
            this.blobStore.deleteBlob(this.blobStore.container(), this.buildKey(blobName));
        }
        catch (StorageException | URISyntaxException e) {
            this.logger.warn("can not access [{}] in container {{}}: {}", (Object)blobName, (Object)this.blobStore.container(), (Object)e.getMessage());
            throw new IOException(e);
        }
    }

    public Map<String, BlobMetaData> listBlobsByPrefix(@Nullable String prefix) throws IOException {
        this.logger.trace("listBlobsByPrefix({})", (Object)prefix);
        try {
            return this.blobStore.listBlobsByPrefix(this.blobStore.container(), this.keyPath, prefix);
        }
        catch (StorageException | URISyntaxException e) {
            this.logger.warn("can not access [{}] in container {{}}: {}", (Object)prefix, (Object)this.blobStore.container(), (Object)e.getMessage());
            throw new IOException(e);
        }
    }

    public void move(String sourceBlobName, String targetBlobName) throws IOException {
        this.logger.trace("move({}, {})", (Object)sourceBlobName, (Object)targetBlobName);
        try {
            String source = this.keyPath + sourceBlobName;
            String target = this.keyPath + targetBlobName;
            this.logger.debug("moving blob [{}] to [{}] in container {{}}", (Object)source, (Object)target, (Object)this.blobStore.container());
            this.blobStore.moveBlob(this.blobStore.container(), source, target);
        }
        catch (StorageException | URISyntaxException e) {
            this.logger.warn("can not move blob [{}] to [{}] in container {{}}: {}", (Object)sourceBlobName, (Object)targetBlobName, (Object)this.blobStore.container(), (Object)e.getMessage());
            throw new IOException(e);
        }
    }

    public Map<String, BlobMetaData> listBlobs() throws IOException {
        this.logger.trace("listBlobs()");
        return this.listBlobsByPrefix(null);
    }

    protected String buildKey(String blobName) {
        return this.keyPath + (blobName == null ? "" : blobName);
    }
}

