/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.MultipartBody;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class MultipartSerializationWriter
implements SerializationWriter {
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private final OutputStreamWriter writer;
    private Consumer<Parsable> onBeforeObjectSerialization;
    private Consumer<Parsable> onAfterObjectSerialization;
    private BiConsumer<Parsable, SerializationWriter> onStartObjectSerialization;

    public MultipartSerializationWriter() {
        try {
            this.writer = new OutputStreamWriter((OutputStream)this.stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("could not create writer", e);
        }
    }

    @Override
    public void writeStringValue(@Nullable String key, @Nullable String value) {
        try {
            if (key != null && !key.isEmpty()) {
                this.writer.write(key);
            }
            if (value != null && !value.isEmpty()) {
                if (key != null && !key.isEmpty()) {
                    this.writer.write(": ");
                }
                this.writer.write(value);
            }
            this.writer.write("\r\n");
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException("could not serialize value", ex);
        }
    }

    @Override
    public void writeBooleanValue(@Nullable String key, @Nullable Boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeShortValue(@Nullable String key, @Nullable Short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeByteValue(@Nullable String key, @Nullable Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeBigDecimalValue(@Nullable String key, @Nullable BigDecimal value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeIntegerValue(@Nullable String key, @Nullable Integer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeFloatValue(@Nullable String key, @Nullable Float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeDoubleValue(@Nullable String key, @Nullable Double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeLongValue(@Nullable String key, @Nullable Long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUUIDValue(@Nullable String key, @Nullable UUID value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeOffsetDateTimeValue(@Nullable String key, @Nullable OffsetDateTime value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeLocalDateValue(@Nullable String key, @Nullable LocalDate value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeLocalTimeValue(@Nullable String key, @Nullable LocalTime value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writePeriodAndDurationValue(@Nullable String key, @Nullable PeriodAndDuration value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void writeCollectionOfPrimitiveValues(@Nullable String key, @Nullable Iterable<T> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Parsable> void writeCollectionOfObjectValues(@Nullable String key, @Nullable Iterable<T> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Enum<T>> void writeCollectionOfEnumValues(@Nullable String key, @Nullable Iterable<T> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Parsable> void writeObjectValue(@Nullable String key, @Nullable T value, Parsable ... additionalValuesToMerge) {
        Objects.requireNonNull(additionalValuesToMerge);
        if (value != null) {
            if (this.onBeforeObjectSerialization != null) {
                this.onBeforeObjectSerialization.accept(value);
            }
            if (value instanceof MultipartBody) {
                if (this.onStartObjectSerialization != null) {
                    this.onStartObjectSerialization.accept(value, this);
                }
            } else {
                throw new RuntimeException("expected MultipartBody instance but got " + value.getClass().getName());
            }
            value.serialize(this);
            if (this.onAfterObjectSerialization != null) {
                this.onAfterObjectSerialization.accept(value);
            }
        }
    }

    @Override
    public <T extends Enum<T>> void writeEnumSetValue(@Nullable String key, @Nullable EnumSet<T> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Enum<T>> void writeEnumValue(@Nullable String key, @Nullable T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeNullValue(@Nullable String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public InputStream getSerializedContent() {
        return new ByteArrayInputStream(this.stream.toByteArray());
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.stream.close();
    }

    @Override
    public void writeAdditionalData(@Nonnull Map<String, Object> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnBeforeObjectSerialization() {
        return this.onBeforeObjectSerialization;
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnAfterObjectSerialization() {
        return this.onAfterObjectSerialization;
    }

    @Override
    @Nullable
    public BiConsumer<Parsable, SerializationWriter> getOnStartObjectSerialization() {
        return this.onStartObjectSerialization;
    }

    @Override
    public void setOnBeforeObjectSerialization(@Nullable Consumer<Parsable> value) {
        this.onBeforeObjectSerialization = value;
    }

    @Override
    public void setOnAfterObjectSerialization(@Nullable Consumer<Parsable> value) {
        this.onAfterObjectSerialization = value;
    }

    @Override
    public void setOnStartObjectSerialization(@Nullable BiConsumer<Parsable, SerializationWriter> value) {
        this.onStartObjectSerialization = value;
    }

    @Override
    public void writeByteArrayValue(@Nullable String key, @Nullable @Nonnull byte[] value) {
        if (value != null) {
            try {
                this.stream.write(value);
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }
}

