/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.threatintelligence.hosts.item;

import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.models.security.Host;
import com.microsoft.graph.security.threatintelligence.hosts.item.childhostpairs.ChildHostPairsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosts.item.components.ComponentsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosts.item.cookies.CookiesRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosts.item.hostpairs.HostPairsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosts.item.parenthostpairs.ParentHostPairsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosts.item.passivedns.PassiveDnsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosts.item.passivednsreverse.PassiveDnsReverseRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosts.item.ports.PortsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosts.item.reputation.ReputationRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosts.item.sslcertificates.SslCertificatesRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosts.item.subdomains.SubdomainsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosts.item.trackers.TrackersRequestBuilder;
import com.microsoft.graph.security.threatintelligence.hosts.item.whois.WhoisRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class HostItemRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public ChildHostPairsRequestBuilder childHostPairs() {
        return new ChildHostPairsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ComponentsRequestBuilder components() {
        return new ComponentsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CookiesRequestBuilder cookies() {
        return new CookiesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public HostPairsRequestBuilder hostPairs() {
        return new HostPairsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ParentHostPairsRequestBuilder parentHostPairs() {
        return new ParentHostPairsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PassiveDnsRequestBuilder passiveDns() {
        return new PassiveDnsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PassiveDnsReverseRequestBuilder passiveDnsReverse() {
        return new PassiveDnsReverseRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PortsRequestBuilder ports() {
        return new PortsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ReputationRequestBuilder reputation() {
        return new ReputationRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SslCertificatesRequestBuilder sslCertificates() {
        return new SslCertificatesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SubdomainsRequestBuilder subdomains() {
        return new SubdomainsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TrackersRequestBuilder trackers() {
        return new TrackersRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public WhoisRequestBuilder whois() {
        return new WhoisRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public HostItemRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/security/threatIntelligence/hosts/{host%2Did}{?%24expand,%24select}", pathParameters);
    }

    public HostItemRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/security/threatIntelligence/hosts/{host%2Did}{?%24expand,%24select}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nullable
    public Host get() {
        return this.get(null);
    }

    @Nullable
    public Host get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Host)this.requestAdapter.send(requestInfo, errorMapping, Host::createFromDiscriminatorValue);
    }

    @Nullable
    public Host patch(@Nonnull Host body) {
        return this.patch(body, null);
    }

    @Nullable
    public Host patch(@Nonnull Host body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Host)this.requestAdapter.send(requestInfo, errorMapping, Host::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Host body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Host body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public HostItemRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new HostItemRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

