/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.AzureResourceEvidence;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SasTokenEvidence
extends AlertEvidence
implements Parsable {
    public SasTokenEvidence() {
        this.setOdataType("#microsoft.graph.security.sasTokenEvidence");
    }

    @Nonnull
    public static SasTokenEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SasTokenEvidence();
    }

    @Nullable
    public String getAllowedIpAddresses() {
        return (String)this.backingStore.get("allowedIpAddresses");
    }

    @Nullable
    public List<String> getAllowedResourceTypes() {
        return (List)this.backingStore.get("allowedResourceTypes");
    }

    @Nullable
    public List<String> getAllowedServices() {
        return (List)this.backingStore.get("allowedServices");
    }

    @Nullable
    public OffsetDateTime getExpiryDateTime() {
        return (OffsetDateTime)this.backingStore.get("expiryDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("allowedIpAddresses", n -> this.setAllowedIpAddresses(n.getStringValue()));
        deserializerMap.put("allowedResourceTypes", n -> this.setAllowedResourceTypes(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("allowedServices", n -> this.setAllowedServices(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("expiryDateTime", n -> this.setExpiryDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("permissions", n -> this.setPermissions(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("protocol", n -> this.setProtocol(n.getStringValue()));
        deserializerMap.put("signatureHash", n -> this.setSignatureHash(n.getStringValue()));
        deserializerMap.put("signedWith", n -> this.setSignedWith(n.getStringValue()));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("storageResource", n -> this.setStorageResource((AzureResourceEvidence)n.getObjectValue(AzureResourceEvidence::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<String> getPermissions() {
        return (List)this.backingStore.get("permissions");
    }

    @Nullable
    public String getProtocol() {
        return (String)this.backingStore.get("protocol");
    }

    @Nullable
    public String getSignatureHash() {
        return (String)this.backingStore.get("signatureHash");
    }

    @Nullable
    public String getSignedWith() {
        return (String)this.backingStore.get("signedWith");
    }

    @Nullable
    public OffsetDateTime getStartDateTime() {
        return (OffsetDateTime)this.backingStore.get("startDateTime");
    }

    @Nullable
    public AzureResourceEvidence getStorageResource() {
        return (AzureResourceEvidence)this.backingStore.get("storageResource");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("allowedIpAddresses", this.getAllowedIpAddresses());
        writer.writeCollectionOfPrimitiveValues("allowedResourceTypes", this.getAllowedResourceTypes());
        writer.writeCollectionOfPrimitiveValues("allowedServices", this.getAllowedServices());
        writer.writeOffsetDateTimeValue("expiryDateTime", this.getExpiryDateTime());
        writer.writeCollectionOfPrimitiveValues("permissions", this.getPermissions());
        writer.writeStringValue("protocol", this.getProtocol());
        writer.writeStringValue("signatureHash", this.getSignatureHash());
        writer.writeStringValue("signedWith", this.getSignedWith());
        writer.writeOffsetDateTimeValue("startDateTime", this.getStartDateTime());
        writer.writeObjectValue("storageResource", (Parsable)this.getStorageResource(), new Parsable[0]);
    }

    public void setAllowedIpAddresses(@Nullable String value) {
        this.backingStore.set("allowedIpAddresses", (Object)value);
    }

    public void setAllowedResourceTypes(@Nullable List<String> value) {
        this.backingStore.set("allowedResourceTypes", value);
    }

    public void setAllowedServices(@Nullable List<String> value) {
        this.backingStore.set("allowedServices", value);
    }

    public void setExpiryDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("expiryDateTime", (Object)value);
    }

    public void setPermissions(@Nullable List<String> value) {
        this.backingStore.set("permissions", value);
    }

    public void setProtocol(@Nullable String value) {
        this.backingStore.set("protocol", (Object)value);
    }

    public void setSignatureHash(@Nullable String value) {
        this.backingStore.set("signatureHash", (Object)value);
    }

    public void setSignedWith(@Nullable String value) {
        this.backingStore.set("signedWith", (Object)value);
    }

    public void setStartDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setStorageResource(@Nullable AzureResourceEvidence value) {
        this.backingStore.set("storageResource", (Object)value);
    }
}

