/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.UserAccount;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MailboxEvidence
extends AlertEvidence
implements Parsable {
    public MailboxEvidence() {
        this.setOdataType("#microsoft.graph.security.mailboxEvidence");
    }

    @Nonnull
    public static MailboxEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new MailboxEvidence();
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("primaryAddress", n -> this.setPrimaryAddress(n.getStringValue()));
        deserializerMap.put("upn", n -> this.setUpn(n.getStringValue()));
        deserializerMap.put("userAccount", n -> this.setUserAccount((UserAccount)n.getObjectValue(UserAccount::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getPrimaryAddress() {
        return (String)this.backingStore.get("primaryAddress");
    }

    @Nullable
    public String getUpn() {
        return (String)this.backingStore.get("upn");
    }

    @Nullable
    public UserAccount getUserAccount() {
        return (UserAccount)this.backingStore.get("userAccount");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("primaryAddress", this.getPrimaryAddress());
        writer.writeStringValue("upn", this.getUpn());
        writer.writeObjectValue("userAccount", (Parsable)this.getUserAccount(), new Parsable[0]);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setPrimaryAddress(@Nullable String value) {
        this.backingStore.set("primaryAddress", (Object)value);
    }

    public void setUpn(@Nullable String value) {
        this.backingStore.set("upn", (Object)value);
    }

    public void setUserAccount(@Nullable UserAccount value) {
        this.backingStore.set("userAccount", (Object)value);
    }
}

