/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.AzureResourceEvidence;
import com.microsoft.graph.models.security.IoTDeviceImportanceType;
import com.microsoft.graph.models.security.IpEvidence;
import com.microsoft.graph.models.security.NicEvidence;
import com.microsoft.graph.models.security.UrlEvidence;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class IoTDeviceEvidence
extends AlertEvidence
implements Parsable {
    public IoTDeviceEvidence() {
        this.setOdataType("#microsoft.graph.security.ioTDeviceEvidence");
    }

    @Nonnull
    public static IoTDeviceEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new IoTDeviceEvidence();
    }

    @Nullable
    public String getDeviceId() {
        return (String)this.backingStore.get("deviceId");
    }

    @Nullable
    public String getDeviceName() {
        return (String)this.backingStore.get("deviceName");
    }

    @Nullable
    public String getDevicePageLink() {
        return (String)this.backingStore.get("devicePageLink");
    }

    @Nullable
    public String getDeviceSubType() {
        return (String)this.backingStore.get("deviceSubType");
    }

    @Nullable
    public String getDeviceType() {
        return (String)this.backingStore.get("deviceType");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("deviceId", n -> this.setDeviceId(n.getStringValue()));
        deserializerMap.put("deviceName", n -> this.setDeviceName(n.getStringValue()));
        deserializerMap.put("devicePageLink", n -> this.setDevicePageLink(n.getStringValue()));
        deserializerMap.put("deviceSubType", n -> this.setDeviceSubType(n.getStringValue()));
        deserializerMap.put("deviceType", n -> this.setDeviceType(n.getStringValue()));
        deserializerMap.put("importance", n -> this.setImportance((IoTDeviceImportanceType)n.getEnumValue(IoTDeviceImportanceType::forValue)));
        deserializerMap.put("ioTHub", n -> this.setIoTHub((AzureResourceEvidence)n.getObjectValue(AzureResourceEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("ioTSecurityAgentId", n -> this.setIoTSecurityAgentId(n.getStringValue()));
        deserializerMap.put("ipAddress", n -> this.setIpAddress((IpEvidence)n.getObjectValue(IpEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("isAuthorized", n -> this.setIsAuthorized(n.getBooleanValue()));
        deserializerMap.put("isProgramming", n -> this.setIsProgramming(n.getBooleanValue()));
        deserializerMap.put("isScanner", n -> this.setIsScanner(n.getBooleanValue()));
        deserializerMap.put("macAddress", n -> this.setMacAddress(n.getStringValue()));
        deserializerMap.put("manufacturer", n -> this.setManufacturer(n.getStringValue()));
        deserializerMap.put("model", n -> this.setModel(n.getStringValue()));
        deserializerMap.put("nics", n -> this.setNics(n.getCollectionOfObjectValues(NicEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("operatingSystem", n -> this.setOperatingSystem(n.getStringValue()));
        deserializerMap.put("owners", n -> this.setOwners(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("protocols", n -> this.setProtocols(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("purdueLayer", n -> this.setPurdueLayer(n.getStringValue()));
        deserializerMap.put("sensor", n -> this.setSensor(n.getStringValue()));
        deserializerMap.put("serialNumber", n -> this.setSerialNumber(n.getStringValue()));
        deserializerMap.put("site", n -> this.setSite(n.getStringValue()));
        deserializerMap.put("source", n -> this.setSource(n.getStringValue()));
        deserializerMap.put("sourceRef", n -> this.setSourceRef((UrlEvidence)n.getObjectValue(UrlEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("zone", n -> this.setZone(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public IoTDeviceImportanceType getImportance() {
        return (IoTDeviceImportanceType)((Object)this.backingStore.get("importance"));
    }

    @Nullable
    public AzureResourceEvidence getIoTHub() {
        return (AzureResourceEvidence)this.backingStore.get("ioTHub");
    }

    @Nullable
    public String getIoTSecurityAgentId() {
        return (String)this.backingStore.get("ioTSecurityAgentId");
    }

    @Nullable
    public IpEvidence getIpAddress() {
        return (IpEvidence)this.backingStore.get("ipAddress");
    }

    @Nullable
    public Boolean getIsAuthorized() {
        return (Boolean)this.backingStore.get("isAuthorized");
    }

    @Nullable
    public Boolean getIsProgramming() {
        return (Boolean)this.backingStore.get("isProgramming");
    }

    @Nullable
    public Boolean getIsScanner() {
        return (Boolean)this.backingStore.get("isScanner");
    }

    @Nullable
    public String getMacAddress() {
        return (String)this.backingStore.get("macAddress");
    }

    @Nullable
    public String getManufacturer() {
        return (String)this.backingStore.get("manufacturer");
    }

    @Nullable
    public String getModel() {
        return (String)this.backingStore.get("model");
    }

    @Nullable
    public List<NicEvidence> getNics() {
        return (List)this.backingStore.get("nics");
    }

    @Nullable
    public String getOperatingSystem() {
        return (String)this.backingStore.get("operatingSystem");
    }

    @Nullable
    public List<String> getOwners() {
        return (List)this.backingStore.get("owners");
    }

    @Nullable
    public List<String> getProtocols() {
        return (List)this.backingStore.get("protocols");
    }

    @Nullable
    public String getPurdueLayer() {
        return (String)this.backingStore.get("purdueLayer");
    }

    @Nullable
    public String getSensor() {
        return (String)this.backingStore.get("sensor");
    }

    @Nullable
    public String getSerialNumber() {
        return (String)this.backingStore.get("serialNumber");
    }

    @Nullable
    public String getSite() {
        return (String)this.backingStore.get("site");
    }

    @Nullable
    public String getSource() {
        return (String)this.backingStore.get("source");
    }

    @Nullable
    public UrlEvidence getSourceRef() {
        return (UrlEvidence)this.backingStore.get("sourceRef");
    }

    @Nullable
    public String getZone() {
        return (String)this.backingStore.get("zone");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("deviceId", this.getDeviceId());
        writer.writeStringValue("deviceName", this.getDeviceName());
        writer.writeStringValue("devicePageLink", this.getDevicePageLink());
        writer.writeStringValue("deviceSubType", this.getDeviceSubType());
        writer.writeStringValue("deviceType", this.getDeviceType());
        writer.writeEnumValue("importance", (Enum)this.getImportance());
        writer.writeObjectValue("ioTHub", (Parsable)this.getIoTHub(), new Parsable[0]);
        writer.writeStringValue("ioTSecurityAgentId", this.getIoTSecurityAgentId());
        writer.writeObjectValue("ipAddress", (Parsable)this.getIpAddress(), new Parsable[0]);
        writer.writeBooleanValue("isAuthorized", this.getIsAuthorized());
        writer.writeBooleanValue("isProgramming", this.getIsProgramming());
        writer.writeBooleanValue("isScanner", this.getIsScanner());
        writer.writeStringValue("macAddress", this.getMacAddress());
        writer.writeStringValue("manufacturer", this.getManufacturer());
        writer.writeStringValue("model", this.getModel());
        writer.writeCollectionOfObjectValues("nics", this.getNics());
        writer.writeStringValue("operatingSystem", this.getOperatingSystem());
        writer.writeCollectionOfPrimitiveValues("owners", this.getOwners());
        writer.writeCollectionOfPrimitiveValues("protocols", this.getProtocols());
        writer.writeStringValue("purdueLayer", this.getPurdueLayer());
        writer.writeStringValue("sensor", this.getSensor());
        writer.writeStringValue("serialNumber", this.getSerialNumber());
        writer.writeStringValue("site", this.getSite());
        writer.writeStringValue("source", this.getSource());
        writer.writeObjectValue("sourceRef", (Parsable)this.getSourceRef(), new Parsable[0]);
        writer.writeStringValue("zone", this.getZone());
    }

    public void setDeviceId(@Nullable String value) {
        this.backingStore.set("deviceId", (Object)value);
    }

    public void setDeviceName(@Nullable String value) {
        this.backingStore.set("deviceName", (Object)value);
    }

    public void setDevicePageLink(@Nullable String value) {
        this.backingStore.set("devicePageLink", (Object)value);
    }

    public void setDeviceSubType(@Nullable String value) {
        this.backingStore.set("deviceSubType", (Object)value);
    }

    public void setDeviceType(@Nullable String value) {
        this.backingStore.set("deviceType", (Object)value);
    }

    public void setImportance(@Nullable IoTDeviceImportanceType value) {
        this.backingStore.set("importance", (Object)value);
    }

    public void setIoTHub(@Nullable AzureResourceEvidence value) {
        this.backingStore.set("ioTHub", (Object)value);
    }

    public void setIoTSecurityAgentId(@Nullable String value) {
        this.backingStore.set("ioTSecurityAgentId", (Object)value);
    }

    public void setIpAddress(@Nullable IpEvidence value) {
        this.backingStore.set("ipAddress", (Object)value);
    }

    public void setIsAuthorized(@Nullable Boolean value) {
        this.backingStore.set("isAuthorized", (Object)value);
    }

    public void setIsProgramming(@Nullable Boolean value) {
        this.backingStore.set("isProgramming", (Object)value);
    }

    public void setIsScanner(@Nullable Boolean value) {
        this.backingStore.set("isScanner", (Object)value);
    }

    public void setMacAddress(@Nullable String value) {
        this.backingStore.set("macAddress", (Object)value);
    }

    public void setManufacturer(@Nullable String value) {
        this.backingStore.set("manufacturer", (Object)value);
    }

    public void setModel(@Nullable String value) {
        this.backingStore.set("model", (Object)value);
    }

    public void setNics(@Nullable List<NicEvidence> value) {
        this.backingStore.set("nics", value);
    }

    public void setOperatingSystem(@Nullable String value) {
        this.backingStore.set("operatingSystem", (Object)value);
    }

    public void setOwners(@Nullable List<String> value) {
        this.backingStore.set("owners", value);
    }

    public void setProtocols(@Nullable List<String> value) {
        this.backingStore.set("protocols", value);
    }

    public void setPurdueLayer(@Nullable String value) {
        this.backingStore.set("purdueLayer", (Object)value);
    }

    public void setSensor(@Nullable String value) {
        this.backingStore.set("sensor", (Object)value);
    }

    public void setSerialNumber(@Nullable String value) {
        this.backingStore.set("serialNumber", (Object)value);
    }

    public void setSite(@Nullable String value) {
        this.backingStore.set("site", (Object)value);
    }

    public void setSource(@Nullable String value) {
        this.backingStore.set("source", (Object)value);
    }

    public void setSourceRef(@Nullable UrlEvidence value) {
        this.backingStore.set("sourceRef", (Object)value);
    }

    public void setZone(@Nullable String value) {
        this.backingStore.set("zone", (Object)value);
    }
}

